<?php
	/*Database Connection*/
	include("dbconnection.php");
?>
<!doctype html>
<html class="no-js" lang="zxx">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="x-ua-compatible" content="ie=edge">
		<title>Export/Import - MySQL Data</title>
		<meta name="description" content="">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="shortcut icon" type="image/x-icon" href="images/favicon.ico">
		<link href="https://fonts.googleapis.com/css?family=Lato:400,700,900" rel="stylesheet">
		<link rel="stylesheet" href="assets/css/bootstrap.min.css">
		<link rel="stylesheet" href="assets/css/meanmenu.css">
		<link rel="stylesheet" href="assets/css/font-awesome.min.css">
		<link rel="stylesheet" href="assets/css/animate.css">
		<link rel="stylesheet" href="assets/css/global.css">
		<!-- style css -->
		<link rel="stylesheet" href="assets/css/style.css">
		<!-- dataTable css-->
		<link href="assets/datatable/css/dataTables.bootstrap4.min.css" rel="stylesheet">
		<link href="assets/datatable/css/responsive.bootstrap4.min.css" rel="stylesheet">
		<!-- export import css -->
		<link rel="stylesheet" href="assets/css/export_import.css?ver=2.3">
		
	</head>
	<body>
		 <!-- scrollToTop -->	
		 <a href="#top" class="scroll-to-top">
			<i class="fa fa-arrow-up"></i>
		</a><!-- /scrollToTop -->
		
		<!-- header -->
		<?php require('header.php'); ?>
		<!-- /header -->

		<!-- PhpSpreadsheet Library Section -->
		<section class="pt-100 pb-50" style="min-height:700px;">
			<div class="container">
				<div class="row">
					<div class="col">
						<div class="section-heading mb-20">
							<h2>Excel Imported Data List</h2>
						</div>
					</div>
				</div>
				<!-- Excel Export -->
				<div class="row">
					<div class="col-lg-12">
						<div class="panel-area">
							<div class="panel-header">
								<div class="inner-panel">
									<h5 class="rules-title">Data List</h5>
								</div>
							</div>
							<div class="panel-content">
								<div class="table-responsive">
									<table id="DataTable_Id" class="table table-striped table-bordered table-hover" cellspacing="0" width="100%">
										<thead>
											<tr>
												<th class="txt-center" style="width:5%;">SL</th>
												<th style="width:35%;">Item Name</th> 
												<th style="width:15%;">Item Code</th> 
												<th style="width:15%;">Date</th> 
												<th class="txt-right" style="width:15%;">Price</th> 
												<th class="txt-right" style="width:15%;">Quantity</th> 
											</tr> 
										</thead> 
										<tbody>
											<?php
												/*sql*/
												$sql = "SELECT id, ItemName, ItemCode,`Date`, Price, Quantity 
												FROM imported_data WHERE EItype = 'excel' AND libType = 'PhpSpreadsheet' ORDER BY id DESC;";
												$result = $pdo->query($sql);
												$i=1; 
												while ($aRow = $result->fetch(PDO::FETCH_ASSOC)){
											?>
											<tr> 
												<td class="txt-center"><?php echo $i++; ?></td> 
												<td><?php echo $aRow['ItemName']; ?></td> 
												<td><?php echo $aRow['ItemCode']; ?></td> 
												<td><?php echo $aRow['Date']; ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Price']); ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Quantity']); ?></td>
											</tr> 
											<?php }	?>
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
				</div><!--end of row-->
			</div>
		</section>
		<!-- /PhpSpreadsheet Library Section -->
		
		<!-- Footer Section -->
		<?php require('footer.php'); ?>
		<!-- /Footer Section -->
		<!-- jquery js -->
		<script src="assets/js/jquery-1.12.4.min.js"></script>
		<script src="assets/js/popper.min.js"></script>
		<script src="assets/js/bootstrap.min.js"></script>
		<script src="assets/js/jquery.meanmenu.min.js"></script>
		<script src="assets/js/jquery.easing.min.js"></script>
		<script src="assets/js/scrolltotop.js"></script>	
		<!-- dataTable js -->
		<script src="assets/datatable/js/jquery.dataTables.min.js"></script>
		<script src="assets/datatable/js/dataTables.bootstrap4.min.js"></script>
		<script src="assets/datatable/js/dataTables.responsive.min.js"></script>
		<script src="assets/datatable/js/responsive.bootstrap4.min.js"></script>
		<script>
			$(document).ready(function() {
				var table = $('#DataTable_Id').DataTable( {
					responsive: true
				} );
			} );
		</script>		
		<!-- main js -->
		<script src="assets/js/main.js?ver=2.3"></script>

	</body>
</html>
