<!doctype html>
<html class="no-js" lang="zxx">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="x-ua-compatible" content="ie=edge">
		<title>NeftEnergies - bulk Import</title>
		<meta name="description" content="">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
		<link href="https://fonts.googleapis.com/css?family=Lato:400,700,900" rel="stylesheet">
		<link rel="stylesheet" href="assets/css/bootstrap.min.css">
		<link rel="stylesheet" href="assets/css/meanmenu.css">
		<link rel="stylesheet" href="assets/css/font-awesome.min.css">
		<link rel="stylesheet" href="assets/css/animate.css">
		<link rel="stylesheet" href="assets/css/global.css">
		<!-- style css -->
		<link rel="stylesheet" href="assets/css/style.css">
		<!-- export import css -->
		<link rel="stylesheet" href="assets/css/et-line.css">
		<link rel="stylesheet" href="assets/css/export_import.css?ver=2.3">
		<style>
		    .scene {
              position: relative;
              z-index: 2;
              height: 220px;
              width: 220px;
              display: none;
              place-items: center;
              margin: 0 auto;
            }
            
            .cube-wrapper {
              transform-style: preserve-3d;
              animation: bouncing 2s infinite;
            }
            
            .cube {
              transform-style: preserve-3d;
              transform: rotateX(45deg) rotateZ(45deg);
              animation: rotation 2s infinite;
            }
            
            .cube-faces {
              transform-style: preserve-3d;
              height: 80px;
              width: 80px;
              position: relative;
              transform-origin: 0 0;
              transform: translateX(0) translateY(0) translateZ(-40px);
            }
            
            .cube-face {
              position: absolute;
              inset: 0;
              background: #110d31ff;
              border: solid 1px #ff8484ff;
            }
            .cube-face.shadow {
              transform: translateZ(-80px);
              animation: bouncing-shadow 2s infinite;
            }
            .cube-face.top {
              transform: translateZ(80px);
            }
            .cube-face.front {
              transform-origin: 0 50%;
              transform: rotateY(-90deg);
            }
            .cube-face.back {
              transform-origin: 0 50%;
              transform: rotateY(-90deg) translateZ(-80px);
            }
            .cube-face.right {
              transform-origin: 50% 0;
              transform: rotateX(-90deg) translateY(-80px);
            }
            .cube-face.left {
              transform-origin: 50% 0;
              transform: rotateX(-90deg) translateY(-80px) translateZ(80px);
            }
            
            @keyframes rotation {
              0% {
                transform: rotateX(45deg) rotateY(0) rotateZ(45deg);
                animation-timing-function: cubic-bezier(0.17, 0.84, 0.44, 1);
              }
              50% {
                transform: rotateX(45deg) rotateY(0) rotateZ(225deg);
                animation-timing-function: cubic-bezier(0.76, 0.05, 0.86, 0.06);
              }
              100% {
                transform: rotateX(45deg) rotateY(0) rotateZ(405deg);
                animation-timing-function: cubic-bezier(0.17, 0.84, 0.44, 1);
              }
            }
            @keyframes bouncing {
              0% {
                transform: translateY(-40px);
                animation-timing-function: cubic-bezier(0.76, 0.05, 0.86, 0.06);
              }
              45% {
                transform: translateY(40px);
                animation-timing-function: cubic-bezier(0.23, 1, 0.32, 1);
              }
              100% {
                transform: translateY(-40px);
                animation-timing-function: cubic-bezier(0.76, 0.05, 0.86, 0.06);
              }
            }
            @keyframes bouncing-shadow {
              0% {
                transform: translateZ(-80px) scale(1.3);
                animation-timing-function: cubic-bezier(0.76, 0.05, 0.86, 0.06);
                opacity: 0.05;
              }
              45% {
                transform: translateZ(0);
                animation-timing-function: cubic-bezier(0.23, 1, 0.32, 1);
                opacity: 0.3;
              }
              100% {
                transform: translateZ(-80px) scale(1.3);
                animation-timing-function: cubic-bezier(0.76, 0.05, 0.86, 0.06);
                opacity: 0.05;
              }
            }
		</style>
		
	</head>
	<body>
		 <!-- scrollToTop -->	
		 <a href="#top" class="scroll-to-top">
			<i class="fa fa-arrow-up"></i>
		</a><!-- /scrollToTop -->
		
		<!-- header -->
		<?php require('header.php'); ?>
		<!-- /header -->

		<!-- PhpSpreadsheet Library Section -->
		<section class="pt-150 pb-150" style="min-height:700px;">
			<div class="container">
				<div class="row">
				  <div class="col-md-6 offset-md-3">
					<!--Upload Box-->
					<div class="tp-upload-box">
						<form id="uploadForm" action="upload.php" method="post" enctype="multipart/form-data">
							<div class="tp-header">
								Excel Import
							</div>
							<div class="tp-body">
								<div class="tp-file-upload">
									<input type="text" name="selectFile" id="selectFile" value="Choose a file" class="tp-form-control" readonly>
									<div class="file_browse_box">
										<input type="file" name="FileName" id="FileName" class="tp-upload">
										<label for="FileName" class="file_browse_icon"><span class="icon-upload"></span>Browse</label>
									</div>
								</div>
								<div class="scene">
                                  <div class="cube-wrapper">
                                    <div class="cube">
                                      <div class="cube-faces">
                                        <div class="cube-face shadow"></div>
                                        <div class="cube-face bottom"></div>
                                        <div class="cube-face top"></div>
                                        <div class="cube-face left"></div>
                                        <div class="cube-face right"></div>
                                        <div class="cube-face back"></div>
                                        <div class="cube-face front"></div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                                
                                </div>
								<div class="selectFile text-left"></div>
								<div class="SuccessMgs display-none"></div>
							</div>
							<div class="tp-footer text-right">
								<input type="submit" value="Upload" class="tp-btn blue-btn tp-b-radius-5"/>
							</div>
						</form>
					</div>
					<!--/Upload Box-->
				  </div>
				</div>
			</div>
		</section>
		<!-- /PhpSpreadsheet Library Section -->
		
		<!-- Footer Section -->
		<?php require('footer.php'); ?>
		<!-- /Footer Section -->
		<!-- jquery js -->
		<script src="assets/js/jquery-1.12.4.min.js"></script>
		<script src="assets/js/popper.min.js"></script>
		<script src="assets/js/bootstrap.min.js"></script>
		<script src="assets/js/jquery.meanmenu.min.js"></script>
		<script src="assets/js/jquery.easing.min.js"></script>
		<script src="assets/js/scrolltotop.js"></script>
		<!-- main js -->
		<script src="assets/js/main.js?ver=2.3"></script>
		
		<!-- upload js -->
		<script src="ps-excel-import-demo-6.js?ver=2.3" type="text/javascript"></script>

	</body>
</html>
