<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title>NEFT Energies</title>
		<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
		<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
		<link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css" rel="stylesheet" />
		

	</head>
	<body>
		<div class="container">
			<br />
            <img src="logo.png" alt="HTML5 Icon" style="width:165px;">
			<br />
			<h2 align="center">NEFT Energies Certificate Verification</h2><br />

            <div  class="row">
                <div class="form-group">
                    <div claas="col-md-2"></div>
                    <div class="col-md-8">
                    <div  class="input-group">
                            <span class="input-group-addon">NEFT Certificate No.</span>
                            <input type="text" name="search_text" id="search_text" placeholder="NEFT12345" class="form-control" />
                    </div>
                    </div>
                    <div class="col-md-2">
                        <input type="button" name="verify" id="verify" class="btn btn-success" value="Search">
                    </div>
                </div>

            </div>

			<br />
			<div id="result"></div>

            <div class="row">
                <div class="panel panel-warning">
                    <div class="panel-heading">Information/Instructions</div>
                    <div class="panel-body">
                        *You can only search by NEFT Energies Certificate No. for example "NEFT12345" or "NEFT - 2024 - 12345".
                        <br>
                        *Please type Certificate no. Exactly as mentioned on card.
                        <br>
                        *Online Records will be updated at the end of each work day.
                    </div>
                </div>

            </div>

		</div>
		<div style="clear:both"></div>
		<br />
		
		<br />
		<br />
		<br />
		
		
		
		
	</body>
</html>


<script>
$(document).ready(function () {
    // Function to format dates
    function formatDates() {
        // Select all expiry-date cells and format their content
        document.querySelectorAll(".expiry-date").forEach(td => {
            let rawDate = td.textContent.trim(); // Get the raw date text
            let formattedDate = new Date(rawDate).toLocaleDateString("en-GB", {
                day: '2-digit',
                month: 'short',
                year: 'numeric'
            });
            td.textContent = formattedDate; // Update the text content with formatted date
        });
    }

    // Function to load data via AJAX
    function load_data(query) {
        $.ajax({
            url: "fetch.php", // Fetch data from the backend
            method: "post",
            data: { query: query }, // Send the search query
            success: function (data) {
                $('#result').html(data); // Replace the #result content
                formatDates(); // Apply date formatting to the newly loaded content
            }
        });
    }

    // Event handler for the Verify button
    $('#verify').click(function () {
        var search = $('#search_text').val(); // Get the search input
        if (search !== '') {
            load_data(search); // Fetch specific data
        } else {
            load_data(); // Load default data
        }
    });
});

</script>


