<?php

/**
 * Checkout coupon form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-coupon.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.9.0
 */

defined('ABSPATH') || exit;

if (!wc_coupons_enabled()) { // @codingStandardsIgnoreLine.
	return;
}

?>
<div class="tj-checkout-billing-coupon">
	<div class="woocommerce-form-coupon-toggle">
		<?php wc_print_notice(apply_filters('woocommerce_checkout_coupon_message', esc_html__('Have a coupon?', 'bexon') . ' <a href="#" class="showcoupon">' . esc_html__('Click here to enter your code', 'bexon') . '</a>'), 'notice'); ?>
	</div>

	<form class="checkout_coupon woocommerce-form-coupon" method="post" style="display:none">

		<p><?php esc_html_e('If you have a coupon code, please apply it below.', 'bexon'); ?></p>

		<div class="d-flex align-items-center flex-wrap rg-30">
			<div class="form-row form-row-first">
				<label for="coupon_code" class="screen-reader-text"><?php esc_html_e('Coupon:', 'bexon'); ?></label>
				<input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_attr_e('Coupon code', 'bexon'); ?>" id="coupon_code" value="" />
			</div>
			<div class="form-row form-row-last">
				<button type="submit" class="tj-primary-btn button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="apply_coupon" value="<?php esc_attr_e('Apply coupon', 'bexon'); ?>">
					<span class="btn-text"><span><?php esc_html_e('Apply coupon', 'bexon'); ?></span></span>
					<span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
				</button>
			</div>
		</div>
		<div class="clear"></div>
	</form>
</div>