<?php

/**
 * Template part for displaying default header layout
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

// info
$header_sticky = get_theme_mod('header_sticky', false);
$header_absolute = get_theme_mod('header_absolute', false);
$sticky_direction = get_theme_mod('sticky_direction');

$isHeaderSticky = !empty($header_sticky && $sticky_direction) ? get_theme_mod('sticky_direction') : "";
$isHeaderAbsolute = !empty($header_absolute) ? "header-absolute" : "";

// header right
$showHeaderButton = get_theme_mod('show_header_button', false);
$headerButtonText = get_theme_mod('header_btn_text', esc_html__('Let’s Talk', 'bexon'));
$headerButtonLink = get_theme_mod('header_btn_link', esc_attr("#"));
?>

<header class="header-area wp-header header-1 section-gap-x <?php printf("%s", esc_attr($isHeaderAbsolute)); ?>">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
        <div class="header-wrapper">
          <!-- site logo -->
          <div class="site_logo">
            <?php bexon_header_logo(); ?>
          </div>

          <!-- navigation -->
          <div class="menu-area d-none d-lg-inline-flex align-items-center">
            <nav class="mainmenu" id="mobile-menu">
              <?php bexon_header_menu(); ?>
            </nav>
          </div>

          <?php if (!empty($showHeaderButton)) : ?>
            <!-- header right info -->
            <div class="header-right-item d-none d-lg-inline-flex">
              <div class="header-button">
                <a class="tj-primary-btn" href="<?php echo esc_attr($headerButtonLink); ?>">
                  <span class="btn-text"><span><?php echo esc_html($headerButtonText); ?></span></span>
                  <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                </a>
              </div>
            </div>
          <?php endif; ?>
          <!-- menu bar -->
          <div class="menu_bar mobile_menu_bar d-lg-none">
            <span></span>
            <span></span>
            <span></span>
          </div>
        </div>
      </div>
    </div>
  </div>
</header>

<header class="header-area header-1 header-duplicate section-gap-x <?php printf("%s", esc_attr($isHeaderSticky)); ?>">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
        <div class="header-wrapper">
          <!-- site logo -->
          <div class="site_logo">
            <?php bexon_header_logo(); ?>
          </div>

          <!-- navigation -->
          <div class="menu-area d-none d-lg-inline-flex align-items-center">
            <nav class="mainmenu" id="mobile-menu">
              <?php bexon_header_menu(); ?>
            </nav>
          </div>

          <?php if (!empty($showHeaderButton)) : ?>
            <!-- header right info -->
            <div class="header-right-item d-none d-lg-inline-flex">
              <div class="header-button">
                <a class="tj-primary-btn" href="<?php echo esc_attr($headerButtonLink); ?>">
                  <span class="btn-text"><span><?php echo esc_html($headerButtonText); ?></span></span>
                  <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                </a>
              </div>
            </div>
          <?php endif; ?>

          <!-- menu bar -->
          <div class="menu_bar mobile_menu_bar d-lg-none">
            <span></span>
            <span></span>
            <span></span>
          </div>
        </div>
      </div>
    </div>
  </div>
</header>
<!-- end: Header -->

<!-- start: Hamburger Menu -->
<div class="body-overlay"></div>

<div class="hamburger-area d-lg-none">
  <div class="hamburger_bg"></div>
  <div class="hamburger_wrapper">
    <div class="hamburger_inner">
      <div class="hamburger_top d-flex align-items-center justify-content-between">

        <div class="hamburger_logo">
          <?php bexon_mobile_logo(); ?>
        </div>

        <div class="hamburger_close">
          <button class="hamburger_close_btn"><i class="fa-thin fa-times"></i></button>
        </div>

      </div>
      <!-- mobile menu -->
      <div class="hamburger_menu">
        <div class="mobile_menu"></div>
      </div>

    </div>
  </div>
</div>

<!-- end: Hamburger Menu -->