<?php

/**
 * Template part for displaying default footer layout
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

$footerBgImage = get_theme_mod('footer_bg_img');
$footerBgColor = get_theme_mod('footer_bg_color', "");

// footer_columns
$footer_column = 0;
$footer_column = get_theme_mod('footer_widget_column', 4);

switch ($footer_column) {
  case '1':
    $footer_class[1] = 'col-12';
    break;
  case '2':
    $footer_class[1] = 'col-md-6';
    $footer_class[2] = 'col-md-6';
    break;
  case '3':
    $footer_class[1] = 'col-lg-4 col-md-6';
    $footer_class[2] = 'col-lg-4 col-md-6';
    $footer_class[3] = 'col-lg-4 col-md-6';
    break;
  case '4':
    $footer_class[1] = 'col-xl-3 col-lg-4 col-md-6';
    $footer_class[2] = 'col-xl-3 col-lg-4 col-md-6';
    $footer_class[3] = 'col-xl-3 col-lg-4 col-md-6';
    $footer_class[4] = 'col-xl-3 col-lg-4 col-md-6';
    break;
  default:
    $footer_class = 'col-xl-3 col-lg-4 col-md-6';
    break;
}

// footer bg color
if (!empty($footerBgColor)) {
  $bgColor = 'data-bg-color=' . $footerBgColor . '';
} else {
  $bgColor = "";
}

// footer bg image
if (!empty($footerBgImage)) {
  $bgImage = 'data-bg-image=' . $footerBgImage . '';
} else {
  $bgImage = "";
}
?>
<!-- Start: Footer Section -->
<footer class="tj-footer-section footer-1 section-gap-x" <?php echo esc_attr($bgColor); ?> <?php echo esc_attr($bgImage); ?>>
  <?php if (is_active_sidebar('footer-1') or is_active_sidebar('footer-2') or is_active_sidebar('footer-3') or is_active_sidebar('footer-4')) : ?>
    <div class="footer-main-area p-0">
      <div class="container">
        <div class="tj-widget-area">
          <div class="row justify-content-between">
            <?php for ($num = 1; $num <= $footer_column; $num++) {
              echo '<div class="' . esc_attr($footer_class[$num]) . '">';
              dynamic_sidebar('footer-' . $num);
              echo '</div>';
            } ?>
          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>
  <div class="tj-copyright-area">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <div class="copyright-content-area justify-content-center">
            <div class="copyright-text">
              <p><?php echo bexon_copyright_text(); ?></p>
            </div>
          </div>
        </div>
      </div>
    </div>
</footer>
<!-- End: Footer Section -->