<?php

/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

$bexonBlogDate = get_theme_mod('bexon_blog_date', false);

if (is_single()) : ?>

	<!-- single post -->
	<article id="post-<?php the_ID(); ?>" <?php post_class("tj-single-post"); ?>>
		<?php if (has_post_thumbnail()) : ?>
			<!-- post thumbnail -->
			<div class="blog-thumb">
				<?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
			</div>
		<?php endif; ?>
		<div class="blog-content">
			<!-- entry title -->
			<?php the_title('<h2 class="entry-title title">', '</h2>'); ?>
			<!-- entry-meta -->
			<?php get_template_part('template-parts/blog/post-meta-single'); ?>
			<!-- entry content -->
			<div class="tj-entry-content blog-text">
				<?php the_content(); ?>
				<?php
				wp_link_pages([
					'before'      => '<div class="tj-page-links"> <span class="tj-page-links-title">' . esc_html__('Pages:', 'bexon') . '</span>',
					'after'       => '</div>',
					'link_before' => '<span>',
					'link_after'  => '</span>',
					'pagelink'    => '<span class="screen-reader-text">' . esc_html__('Page', 'bexon') . ' </span>%',
					'separator'   => '<span class="screen-reader-text"> </span>',
				]);
				?>
			</div>
		</div>
	</article>
	<!-- !single post -->

<?php else : ?>

	<!-- post-<?php the_ID(); ?> -->
	<article id="post-<?php the_ID(); ?>" <?php post_class("blog-item"); ?>>
		<?php if (has_post_thumbnail()) : ?>
			<!-- post thumbnail -->
			<div class="blog-thumb">
				<a href="<?php the_permalink(); ?>">
					<?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
				</a>
				<?php if (!empty($bexonBlogDate)) : ?>
					<div class="blog-date">
						<span class="date"><?php echo get_the_date('d'); ?></span>
						<span class="month"><?php echo get_the_date('M'); ?></span>
					</div>
				<?php endif; ?>
			</div>
		<?php endif; ?>
		<div class="blog-content">
			<!-- entry-meta -->
			<?php get_template_part('template-parts/blog/post-meta'); ?>
			<!-- entry title -->
			<?php the_title('<h3 class="entry-title title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>
			<?php if (get_the_excerpt()): ?>
				<!-- excerpt -->
				<div class="excerpt desc"><?php echo wp_trim_words(get_the_excerpt(), '40', '...'); ?></div>
			<?php endif; ?>
			<!-- post btn -->
			<?php get_template_part('template-parts/blog/post-btn'); ?>
		</div>
	</article><!-- !post-<?php the_ID(); ?> -->

<?php endif; ?>