<?php

/**
 * Template part for displaying gallery posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

// get gallery images
$galleryImages = function_exists('get_field') ? get_field('post_gallery_images') : '';
$bexonBlogDate = get_theme_mod('bexon_blog_date', false);

if (is_single()) : ?>

  <!-- single post -->
  <article id="post-<?php the_ID(); ?>" <?php post_class("tj-single-post format-gallery"); ?>>
    <?php if (!empty($galleryImages)) : ?>
      <!-- post thumbnail -->
      <div class="blog-gallery-slider swiper-container swiper">
        <div class="swiper-wrapper">
          <?php foreach ($galleryImages as $key => $image) : ?>
            <div class="swiper-slide">
              <div class="blog-thumb">
                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>">
              </div>
            </div>
          <?php endforeach; ?>
        </div>
        <div class="blog-gallery-nav">
          <div class="slider-prev">
            <span class="anim-icon"><i class="tji-arrow-left"></i><i class="tji-arrow-left"></i></span>
          </div>
          <div class="slider-next">
            <span class="anim-icon"><i class="tji-arrow-right"></i><i class="tji-arrow-right"></i></span>
          </div>
        </div>
      </div>
    <?php endif; ?>
    <div class="blog-content">
      <!-- entry title -->
      <?php the_title('<h2 class="entry-title title">', '</h2>'); ?>
      <!-- entry-meta -->
      <?php get_template_part('template-parts/blog/post-meta-single'); ?>
      <!-- entry content -->
      <div class="tj-entry-content blog-text">
        <?php the_content(); ?>
        <?php
        wp_link_pages([
          'before'      => '<div class="tj-page-links"> <span class="tj-page-links-title">' . esc_html__('Pages:', 'bexon') . '</span>',
          'after'       => '</div>',
          'link_before' => '<span>',
          'link_after'  => '</span>',
          'pagelink'    => '<span class="screen-reader-text">' . esc_html__('Page', 'bexon') . ' </span>%',
          'separator'   => '<span class="screen-reader-text"> </span>',
        ]);
        ?>
      </div>
    </div>
  </article>
  <!-- !single post -->

<?php else : ?>

  <!-- post-<?php the_ID(); ?> -->
  <article id="post-<?php the_ID(); ?>" <?php post_class("blog-item format-gallery"); ?>>
    <?php if (!empty($galleryImages)) : ?>
      <!-- post thumbnail -->
      <div class="blog-gallery-slider swiper-container swiper">
        <div class="swiper-wrapper">
          <?php foreach ($galleryImages as $key => $image) : ?>
            <div class="swiper-slide">
              <div class="blog-thumb">
                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>">
                <?php if (!empty($bexonBlogDate)) : ?>
                  <div class="blog-date">
                    <span class="date"><?php echo get_the_date('d'); ?></span>
                    <span class="month"><?php echo get_the_date('M'); ?></span>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
        <div class="blog-gallery-nav">
          <div class="slider-prev">
            <span class="anim-icon"><i class="tji-arrow-left"></i><i class="tji-arrow-left"></i></span>
          </div>
          <div class="slider-next">
            <span class="anim-icon"><i class="tji-arrow-right"></i><i class="tji-arrow-right"></i></span>
          </div>
        </div>
      </div>
    <?php endif; ?>
    <div class="blog-content">
      <!-- entry-meta -->
      <?php get_template_part('template-parts/blog/post-meta'); ?>
      <!-- entry title -->
      <?php the_title('<h3 class="entry-title title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>
      <?php if (get_the_excerpt()): ?>
        <!-- excerpt -->
        <div class="excerpt desc"><?php echo wp_trim_words(get_the_excerpt(), '40', '...'); ?></div>
      <?php endif; ?>
      <!-- post btn -->
      <?php get_template_part('template-parts/blog/post-btn'); ?>
    </div>
  </article><!-- !post-<?php the_ID(); ?> -->

<?php endif; ?>