<?php

/**
 * Template part for displaying post meta
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */
$categories = get_the_terms($post->ID, 'category');
$bexonBlogDate = get_theme_mod('bexon_blog_date', false);
$bexonBlogAuthor = get_theme_mod('bexon_blog_author', false);
$bexonBlogCat = get_theme_mod('bexon_blog_category', false);
if (!empty($bexonBlogAuthor || $bexonBlogDate || $bexonBlogCat)) : ?>
  <div class="entry-meta blog-meta">
    <?php if (!empty($bexonBlogCat)) : ?>
      <?php if (!empty($categories[0]->name)) : ?>
        <span class="categories"><a href="<?php echo esc_url(get_category_link($categories[0]->term_id)); ?>"><?php echo esc_html($categories[0]->name); ?></a> </span>
      <?php endif; ?>
    <?php endif; ?>
    <?php if (!empty($bexonBlogAuthor)) : ?>
      <span><?php echo esc_html__('By', 'bexon'); ?> <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php echo get_the_author(); ?></a></span>
    <?php endif; ?>
    <?php if (!empty($bexonBlogDate)) : ?>
      <span class="d-none"><?php the_time(get_option('date_format')); ?> </span>
    <?php endif; ?>
  </div>
<?php endif; ?>