<?php

/**
 * Template part for displaying post meta
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

$bexonBlogAuthor = get_theme_mod('bexon_blog_single_author', true);
$bexonBlogDate = get_theme_mod('bexon_blog_single_date', true);
$bexonBlogComments = get_theme_mod('bexon_blog_single_comments', true);

$bexonBlogAuthorLabel = get_theme_mod('bexon_blog_single_author_label', esc_html__('Authored by', 'bexon'));
$bexonBlogDateLabel = get_theme_mod('bexon_blog_single_date_label', esc_html__('Date Released', 'bexon'));
$bexonBlogCommentsLabel = get_theme_mod('bexon_blog_single_comments_label', esc_html__('Comments', 'bexon'));

$author_id = get_the_author_meta('ID');
$user_photo = function_exists('get_field') ? get_field('user_photo', 'user_' . $author_id) : '';

if (!empty($bexonBlogAuthor || $bexonBlogDate || $bexonBlogComments)) : ?>

  <div class="blog-category-two">
    <?php if (!empty($bexonBlogAuthor)) : ?>
      <div class="category-item">
        <div class="cate-images">
          <?php if (!empty($user_photo['url'])) : ?>
            <img src="<?php echo esc_url($user_photo['url']); ?>" alt="Images">
          <?php else : ?>
            <img src="<?php echo esc_url(get_avatar_url(get_the_author_meta('ID'))); ?>" alt="Images">
          <?php endif; ?>
        </div>
        <div class="cate-text">
          <?php if (!empty($bexonBlogAuthorLabel)): ?>
            <span class="degination"><?php echo esc_html($bexonBlogAuthorLabel); ?></span>
          <?php endif; ?>
          <h6 class="title"><?php printf('<a href="%s">%s</a>', esc_url(get_author_posts_url(get_the_author_meta('ID'))), get_the_author()); ?></h6>
        </div>
      </div>
    <?php endif; ?>
    <?php if (!empty($bexonBlogDate)) : ?>
      <div class="category-item">
        <div class="cate-icons">
          <i class="tji-calendar"></i>
        </div>
        <div class="cate-text">
          <?php if (!empty($bexonBlogDateLabel)): ?>
            <span class="degination"><?php echo esc_html($bexonBlogDateLabel); ?></span>
          <?php endif; ?>
          <h6 class="text"><?php the_time('j F, Y'); ?></h6>
        </div>
      </div>
    <?php endif; ?>
    <?php if (!empty($bexonBlogComments)) : ?>
      <div class="category-item">
        <div class="cate-icons">
          <i class="tji-comment"></i>
        </div>
        <div class="cate-text">
          <?php if (!empty($bexonBlogCommentsLabel)): ?>
            <span class="degination"><?php echo esc_html($bexonBlogCommentsLabel); ?></span>
          <?php endif; ?>
          <h6 class="text"><?php comments_number(); ?></h6>
        </div>
      </div>
    <?php endif; ?>
  </div>

<?php endif; ?>