<?php

/**
 * Template Name: Page Sidebar
 * 
 * The template for displaying Page with Sidebar
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

get_header();

$blog_column = is_active_sidebar('blog-sidebar') ? 8 : 12;
?>
<div class="tj-page-area section-gap">
  <div class="container">
    <div class="row row-gap-45">
      <div class="col-lg-<?php print esc_attr($blog_column); ?>">
        <div class="tj-page-container">
          <?php
          if (have_posts()) :
            while (have_posts()) : the_post();
              get_template_part('template-parts/content', 'page');
            endwhile;
          else :
            get_template_part('template-parts/content', 'none');
          endif;
          ?>
        </div>
      </div>

      <?php if (is_active_sidebar('blog-sidebar')) : ?>
        <!-- sidebar -->
        <div class="col-lg-4">
          <aside class="tj-main-sidebar sticky-lg-top">
            <?php get_sidebar(); ?>
          </aside>
        </div>
        <!--!sidebar -->
      <?php endif; ?>
    </div>
  </div>
</div>

<?php
get_footer();
