<?php

/**
 * Bexon Theme Hooks Class
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

if (!function_exists('bexon_setup')) :
  function bexon_setup()
  {

    /* add title tag support */
    add_theme_support('title-tag');

    /* load theme languages */
    load_theme_textdomain('bexon', BEXON_THEME_DIR . '/languages');

    /* Add default posts and comments RSS feed links to head */
    add_theme_support('automatic-feed-links');

    /* Add posts thumbnails */
    add_theme_support('post-thumbnails');

    /*
 * Switch default core markup for search form, comment form, and comments
 * to output valid HTML5.
 */
    add_theme_support(
      'html5',
      [
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
        'script',
        'style',
        'navigation-widgets'
      ]
    );

    /* Set up the WordPress core custom background feature. */
    add_theme_support(
      'custom-background',
      apply_filters(
        'bexon_custom_background_args',
        [
          'default-color' => 'ffffff',
          'default-image' => '',
        ]
      )
    );

    /* Add theme support for selective refresh for widgets. */
    add_theme_support('customize-selective-refresh-widgets');

    /* Enable support for Post Formats. */
    add_theme_support('post-formats', ['image', 'audio', 'video', 'quote']);

    /* Add support for custom header */
    add_theme_support("custom-header");

    /* Add support for core custom logo. */
    add_theme_support('custom-logo', [
      'height'      => 170,
      'width'       => 60,
      'flex-width'  => true,
      'flex-height' => true,
    ]);

    /* Add support for Block Styles. */
    add_theme_support('wp-block-styles');

    /* Add support for full and wide align images. */
    add_theme_support('align-wide');

    /* Add support for editor styles. */
    add_theme_support('editor-styles');

    // Enqueue editor styles.
    add_editor_style('style.css');

    /* Add support for responsive embedded content. */
    add_theme_support('responsive-embeds');

    /* Support for elementor header and footer */
    if (class_exists('Header_Footer_Elementor')) {
      add_theme_support('header-footer-elementor');
    }

    /* Register nav menus. */
    register_nav_menus(
      [
        'main-menu'   => esc_html__('Main Menu', 'bexon'),
      ]
    );
  }

endif;
add_action('after_setup_theme', 'bexon_setup');

function bexon_resigster_block()
{
  // Register block styles  
  if (function_exists('register_block_style')) {
    register_block_style(
      'core/paragraph',
      [
        'name'  => 'bexon-custom-style',
        'label' => __('Custom Style', 'bexon'),
      ]
    );
  }
  // Register block patterns         
  if (function_exists('register_block_pattern')) {
    register_block_pattern(
      'bexon/custom-pattern',
      [
        'title'       => __('Custom Pattern', 'bexon'),
        'description' => _x('A custom block pattern for bexon theme', 'Block pattern description', 'bexon'),
        'content'     => "<!-- wp:paragraph --><p>" . __('Hello World', 'bexon') . "</p><!-- /wp:paragraph -->",
      ]
    );
  }
}
add_action('after_setup_theme', 'bexon_resigster_block');

/**
 *  ---------------------------------------------------------------------------------------
 *  Set the content width in pixels, based on the theme's design and stylesheet.
 *  ---------------------------------------------------------------------------------------
 */
function bexon_content_width()
{
  // This variable is intended to be overruled from themes.
  // Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
  // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
  $GLOBALS['content_width'] = apply_filters('bexon_content_width', 1000);
}
add_action('after_setup_theme', 'bexon_content_width', 0);


/**
 * ---------------------------------------------------------------------------------------
 * Admin Custom Scripts
 * ---------------------------------------------------------------------------------------
 */
function bexon_admin_custom_scripts()
{
  wp_enqueue_media();
  wp_enqueue_style('bexon-customizer-style', BEXON_INC_URL . '/assets/css/customizer-style.css', []);
}
add_action('admin_enqueue_scripts', 'bexon_admin_custom_scripts');



/**
 *    ---------------------------------------------------------------------------------------
 *    Register widget area.
 *
 *  @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 *    ---------------------------------------------------------------------------------------
 */
function bexon_widgets_init()
{
  require_once BEXON_COMMON_DIR . '/template-widgets.php';
}
add_action('widgets_init', 'bexon_widgets_init');


/**
 * ---------------------------------------------------------------------------------------
 *  Enqueue scripts and styles.
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('bexon_scripts')) :
  require_once BEXON_COMMON_DIR . '/template-scripts.php';
endif;


/**
 * ---------------------------------------------------------------------------------------
 * ReArrange Comment Form
 * ---------------------------------------------------------------------------------------
 */
function bexon_rearrange_comment_form($fields)
{

  $comment = $fields['comment'] ?? '';
  $author  = $fields['author'] ?? '';
  $email   = $fields['email'] ?? '';
  $url     = $fields['url'] ?? '';
  $cookies = $fields['cookies'] ?? '';

  unset($fields['comment'], $fields['author'], $fields['email'], $fields['url'], $fields['cookies']);

  $fields['comment'] = $comment;
  $fields['author']  = $author;
  $fields['email']   = $email;
  if (!empty($url)) {
    $fields['url'] = $url;
  }
  if (!empty($cookies)) {
    $fields['cookies'] = $cookies;
  }

  return $fields;
}
add_filter('comment_form_fields', 'bexon_rearrange_comment_form');


/**
 * ---------------------------------------------------------------------------------------
 * Body Class
 * ---------------------------------------------------------------------------------------
 */
function bexon_body_classes($classes)
{

  $header_absolute = get_theme_mod('header_absolute', false);
  $header_sticky = get_theme_mod('header_sticky', false);

  $isHeaderAbsolute = !empty($header_absolute) ? "absolute_header" : "";
  $isHeaderSticky = !empty($header_sticky) ? "sticky_header" : "";

  $classes[]    = $isHeaderAbsolute;
  $classes[]    = $isHeaderSticky;

  // Adds a class of bexon_page to non-singular pages.
  if (!is_singular()) {
    $classes[] = 'bexon_page';
  }

  // Adds a class of no-sidebar when there is no sidebar present.
  if (!is_active_sidebar('blog-sidebar')) {
    $classes[] = 'no-sidebar';
  }

  return $classes;
}
add_filter('body_class', 'bexon_body_classes');
