<?php

/**
 * Functions which enhance the theme by Custom Functions
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

/**
 * ---------------------------------------------------------------------------------------
 * Bexon Before Content
 * ---------------------------------------------------------------------------------------
 */

// Preloader
add_action('wp_body_open', 'bexon_preloader');
function bexon_preloader() {
  $is_preloader_enabled = get_theme_mod('show_preloader', false);
  $selected_preloader   = get_theme_mod('select_preloader', 'style-1');
  $preloader_text   = get_theme_mod('preloader_text', __('Loading...', 'bexon'));
  $default_logo         = BEXON_ASSETS_IMAGES_URL . '/logos/logo-icon.webp';
  $loader_image         = get_theme_mod('preloader_logo', $default_logo);

  if (!$is_preloader_enabled) {
    return;
  }

  // Normalize value (defensive check)
  $valid_styles = ['style-1', 'style-2'];
  if (!in_array($selected_preloader, $valid_styles, true)) {
    $selected_preloader = 'style-1'; // Fallback
  }

  switch ($selected_preloader) {
    case 'style-1':
?>
      <div class="preloader">
        <div class="loading-container">
          <div class="loading"></div>
          <div id="loading-icon">
            <img src="<?php echo esc_url($loader_image); ?>" alt="<?php echo esc_attr(get_post_meta(attachment_url_to_postid($loader_image), '_wp_attachment_image_alt', true)); ?>">
          </div>
        </div>
      </div>
    <?php
      break;

    case 'style-2':
    ?>
      <div class="tj-preloader is-loading">
        <div class="tj-preloader-inner">
          <div class="tj-preloader-ball-wrap">
            <div class="tj-preloader-ball-inner-wrap">
              <div class="tj-preloader-ball-inner">
                <div class="tj-preloader-ball"></div>
              </div>
              <div class="tj-preloader-ball-shadow"></div>
            </div>
            <div id="tj-weave-anim" class="tj-preloader-text"><?php echo bexon_kses($preloader_text); ?></div>
          </div>
        </div>
        <div class="tj-preloader-overlay"></div>
      </div>
    <?php
      break;
  }
}





// Back to Top
add_action('tj_before_main_content', 'bexon_back_to_top');
function bexon_back_to_top() {
  $bexonBackToTop = get_theme_mod('bexon_backtotop', false);

  if (!empty($bexonBackToTop)) : ?>
    <div id="tj-back-to-top"><span id="tj-back-to-top-percentage"></span></div>
    <?php endif;
}

/**
 * ---------------------------------------------------------------------------------------
 * Bexon Search Filter
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('bexon_search_filter_form')) {
  function bexon_search_filter_form($form) {
    $form = sprintf(
      '<div class="tj_search"><div class="search-box"><form action="%s" method="get">
       <input type="search" value="%s" required name="s" placeholder="%s">
       <button type="submit"> <i class="tji-search"></i> </button>
    </form></div></div>',
      esc_url(home_url('/')),
      esc_attr(get_search_query()),
      esc_html__('Search here', 'bexon')
    );
    return $form;
  }
  add_filter('get_search_form', 'bexon_search_filter_form');
}

/**
 * ---------------------------------------------------------------------------------------
 * Bexon Breadcrumb
 * ---------------------------------------------------------------------------------------
 */
add_action('tj_page_header', 'bexon_breadcrumb_func');
function bexon_breadcrumb_func() {
  global $post;

  // id
  $_id = get_the_ID();

  $pheader_class = '';
  $pheader_show = 1;

  $show_page_header = get_theme_mod('show_page_header', true);

  // page breadcrumb title
  $page_pheader_title = function_exists('get_field') ? get_field('page_pheader_title', $_id) : '';

  if (!empty($show_page_header)) :
    // title
    if (is_front_page() && is_home()) {
      $title = get_theme_mod('blog_page_title', esc_html__('Blog', 'bexon'));
      $pheader_class = 'home_front_page';
    } elseif (is_front_page()) {
      $title = get_theme_mod('blog_page_title', esc_html__('Blog', 'bexon'));
      $pheader_show = 0;
    } elseif (is_home()) {
      $title = get_theme_mod('blog_page_title', esc_html__('Blog', 'bexon'));
      $pheader_class = 'home_blog_page';
    } elseif (is_single() && 'post' == get_post_type()) {
      if (!empty($page_pheader_title)) {
        $title =  $page_pheader_title;
      } elseif (!empty(get_theme_mod('blog_single_page_title'))) {
        $title = get_theme_mod('blog_single_page_title', esc_html__('Blog Details', 'bexon'));
      } else {
        $title =  get_the_title();
      }
    } elseif (is_single() && 'product' == get_post_type()) {
      $title =  get_the_title();
    } elseif (is_search()) {
      $title = esc_html__('Search Results for : ', 'bexon') . get_search_query();
    } elseif (is_404()) {
      $title = get_theme_mod('error_page_title',  esc_html__('Not Found', 'bexon'));
    } elseif (function_exists('is_woocommerce') && is_woocommerce()) {
      $title = get_theme_mod('product_page_title', esc_html__('Shop', 'bexon'));
    } elseif (is_archive() && 'services' == get_post_type()) {
      $pheader_class = 'bexon_services_archive';
      if (!empty(get_theme_mod('service_page_title'))) {
        $title = get_theme_mod('service_page_title', esc_html__('Services', 'bexon'));
      } else {
        $title =  get_the_archive_title();
      }
    } elseif (is_single() && 'services' == get_post_type()) {
      $pheader_class = 'bexon_service_single';
      $title = !empty($page_pheader_title) ? $page_pheader_title : get_the_title();
    } elseif (is_archive() && 'projects' == get_post_type()) {
      $pheader_class = 'bexon_projects_archive';
      if (!empty(get_theme_mod('project_page_title'))) {
        $title = get_theme_mod('project_page_title', esc_html__('Projects', 'bexon'));
      } else {
        $title =  get_the_archive_title();
      }
    } elseif (is_single() && 'projects' == get_post_type()) {
      $pheader_class = 'bexon_project_single';
      $title = !empty($page_pheader_title) ? $page_pheader_title : get_the_title();
    } elseif (is_archive()) {
      $title = get_the_archive_title();
    } else {
      $title = !empty($page_pheader_title) ? $page_pheader_title : get_the_title();
    }


    if (is_single() && 'product' == get_post_type()) {
      $_id = $post->ID;
    } elseif (function_exists("is_shop") and is_shop()) {
      $_id = wc_get_page_id('shop');
    } elseif (is_home() && get_option('page_for_posts')) {
      $_id = get_option('page_for_posts');
    }

    // hide page breadcrumb
    if (is_singular() || is_page()) {
      $is_page_header = function_exists('get_field') ? get_field('hide_page_pheader', $_id) : false;
    } else {
      $is_page_header = false;
    }

    if ((false == $is_page_header) && $pheader_show == 1) {
      // IMAGES
      $pheader_page_bg_image = function_exists('get_field') ? get_field('pheader_page_bg_image', $_id) : '';

      // customizer
      $customizer_bg_img = get_theme_mod('page_header_bg_img');
      $overlay_bg_img = get_theme_mod('overlay_bg_img');

      $blog_pheader_img = get_theme_mod('blog_pheader_img');
      $blog_single_pheader_img = get_theme_mod('blog_single_pheader_img');
      $service_pheader_img = get_theme_mod('service_pheader_img');
      $project_pheader_img = get_theme_mod('project_pheader_img');
      $breadcrumb_shop_img = get_theme_mod('breadcrumb_shop_img');
      $error_pheader_img = get_theme_mod('error_pheader_img');

      // image
      if (is_front_page() && is_home()) {
        $bg_img = $blog_pheader_img ? $blog_pheader_img : $customizer_bg_img;
      } elseif (is_front_page()) {
        $bg_img = $blog_pheader_img ? $blog_pheader_img : $customizer_bg_img;
      } elseif (is_home()) {
        $bg_img = $blog_pheader_img ? $blog_pheader_img : $customizer_bg_img;
      } elseif (is_single() && 'post' == get_post_type()) {
        $bg_img = !empty($pheader_page_bg_image['url']) ? $pheader_page_bg_image['url'] : ($blog_single_pheader_img ? $blog_single_pheader_img : $customizer_bg_img);
      } elseif (is_404()) {
        $bg_img = $error_pheader_img ? $error_pheader_img : $customizer_bg_img;
      } elseif (is_archive() && 'services' == get_post_type()) {
        $bg_img = $service_pheader_img ? $service_pheader_img : $customizer_bg_img;
      } elseif (is_single() && 'services' == get_post_type()) {
        $bg_img = !empty($pheader_page_bg_image['url']) ? $pheader_page_bg_image['url'] : ($service_pheader_img ? $service_pheader_img : $customizer_bg_img);
      } elseif (is_archive() && 'projects' == get_post_type()) {
        $bg_img = $project_pheader_img ? $project_pheader_img : $customizer_bg_img;
      } elseif (is_single() && 'projects' == get_post_type()) {
        $bg_img = !empty($pheader_page_bg_image['url']) ? $pheader_page_bg_image['url'] : ($project_pheader_img ? $project_pheader_img : $customizer_bg_img);
      } elseif (is_archive() && 'product' == get_post_type()) {
        $bg_img = $breadcrumb_shop_img ? $breadcrumb_shop_img : $customizer_bg_img;
      } elseif (is_single() && 'product' == get_post_type()) {
        $bg_img = $breadcrumb_shop_img ? $breadcrumb_shop_img : $customizer_bg_img;
      } elseif (is_single()) {
        $bg_img = !empty($pheader_page_bg_image['url']) ? $pheader_page_bg_image['url'] : $customizer_bg_img;
      } else {
        $bg_img = !empty($pheader_page_bg_image['url']) ? $pheader_page_bg_image['url'] : $customizer_bg_img;
      }

      // NAVIGATION
      $show_page_header_nav = get_theme_mod('show_page_header_nav', false);
      $smooth_scroller = get_theme_mod('enable_smooth_scroller', false);
      $is_navigation = $show_page_header_nav;

      // breadcrumb bg image
      if (!empty($bg_img)) {
        $bgImage = 'data-bg-image=' . $bg_img . '';
      } else {
        $bgImage = "";
      }
    ?>

      <?php if (!empty($smooth_scroller)) : ?>
        <div class="pspacer"></div>
      <?php endif; ?>
      <section class="tj-page-header section-gap-x  <?php echo esc_attr($pheader_class); ?>" <?php echo esc_attr($bgImage);  ?>>
        <div class="container">
          <div class="row">
            <div class="col-lg-12">
              <div class="tj-page-header-content text-center">
                <h1 class="tj-page-title"><?php echo bexon_kses($title); ?></h1>
                <?php if (!empty($is_navigation)) : ?>
                  <?php if (function_exists('bcn_display')) : ?>
                    <div class="tj-page-navs">
                      <span><i class="tji-home"></i></span>
                      <?php bcn_display(); ?>
                    </div>
                  <?php endif; ?>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
        <?php if (!empty($overlay_bg_img)) : ?>
          <div class="page-header-overlay" data-bg-image="<?php echo esc_attr($overlay_bg_img);  ?>"></div>
        <?php endif; ?>
      </section>
    <?php
    }
  endif;
}
add_filter('bcn_breadcrumb_title', 'bexon_pheader_current_title_trim', 3, 10);
function bexon_pheader_current_title_trim($title, $type, $id) {
  $parentTitle = get_theme_mod('pagenav_parent_title', esc_html__("Home", 'bexon'));
  if (in_array('home', $type)) {
    $title = esc_html($parentTitle);
  }
  if (in_array('post', $type)) {
    $title = wp_trim_words($title, 4, '...');
  }
  return $title;
}

/**
 * ---------------------------------------------------------------------------------------
 * Bexon Header Logo
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('bexon_header_logo')) {
  function bexon_header_logo() {
    $primaryLogo       = BEXON_ASSETS_IMAGES_URL . '/logos/primary-logo.webp';

    $bexonPrimaryLogo  = get_theme_mod('primary_logo', $primaryLogo);
    ?>
    <?php if (!empty($bexonPrimaryLogo)) : ?>
      <a class="primary_logo logo" href="<?php echo esc_url(home_url('/')); ?>">
        <img src="<?php echo esc_url($bexonPrimaryLogo); ?>" alt="<?php echo esc_attr(get_post_meta(attachment_url_to_postid($bexonPrimaryLogo), '_wp_attachment_image_alt', true)); ?>">
      </a>
    <?php endif; ?>
  <?php
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Bexon Header Mobile Logo
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('bexon_mobile_logo')) {
  function bexon_mobile_logo() {
    $bexonMobileLogo = get_theme_mod('mobile_logo', BEXON_ASSETS_IMAGES_URL . '/logos/secondary-logo.webp');
  ?>
    <a href="<?php echo esc_url(home_url('/')); ?>" class="mobile_logo">
      <img src="<?php echo esc_url($bexonMobileLogo); ?>" alt="<?php echo esc_attr(get_post_meta(attachment_url_to_postid($bexonMobileLogo), '_wp_attachment_image_alt', true)); ?>">
    </a>
  <?php   }
}

/**
 * ---------------------------------------------------------------------------------------
 * Bexon Header Menu
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('bexon_header_menu')) {
  function bexon_header_menu() {

    if (has_nav_menu('main-menu')) {
      wp_nav_menu([
        'theme_location' => 'main-menu',
        'menu_class'     => '',
        'menu_id'        => '',
        'container'      => '',
        'fallback_cb'    => 'TJ_Navwalker_Class::fallback',
        'walker'         => new \TJCore\TJ_Navwalker_Class,
      ]);
    } else {
      wp_nav_menu([
        'menu_class'     => '',
        'container'      => '',
      ]);
    }
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Bexon Copyright Text
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('bexon_copyright_text')) {
  function bexon_copyright_text() {
    $bexon_copyright = get_theme_mod('bexon_copyright', bexon_kses('© 2025 Bexon, All Rights Reserved. Design By <a href="#">Theme Junction</a>'));
    echo bexon_kses($bexon_copyright);
  }
}


/**
 * ---------------------------------------------------------------------------------------
 * Bexon Pagination
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('bexon_pagination')) {

  function _bexon_pagi_callback($pagination) {
    return $pagination;
  }

  //page navigation
  function bexon_pagination($prev, $next, $pages, $args) {
    global $wp_query, $wp_rewrite;
    $menu                                         = '';
    $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;

    if ($pages == '') {
      global $wp_query;
      $pages = $wp_query->max_num_pages;

      if (!$pages) {
        $pages = 1;
      }
    }

    $pagination = [
      'base'      => add_query_arg('paged', '%#%'),
      'format'    => '',
      'total'     => $pages,
      'current'   => $current,
      'prev_text' => $prev,
      'next_text' => $next,
      'type'      => 'array',
    ];

    //rewrite permalinks
    if ($wp_rewrite->using_permalinks()) {
      $pagination['base'] = user_trailingslashit(trailingslashit(remove_query_arg('s', get_pagenum_link(1))) . 'page/%#%/', 'paged');
    }

    if (!empty($wp_query->query_vars['s'])) {
      $pagination['add_args'] = ['s' => get_query_var('s')];
    }

    $pagi = '';
    if (paginate_links($pagination) != '') {
      $paginations = paginate_links($pagination);
      $pagi .= '<ul>';
      foreach ($paginations as $key => $pg) {
        $pagi .= '<li>' . $pg . '</li>';
      }
      $pagi .= '</ul>';
    }

    echo _bexon_pagi_callback($pagi);
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Bexon Comment
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('bexon_comment')) {
  function bexon_comment($comment, $args, $depth) {
    $GLOBAL['comment'] = $comment;
    extract($args, EXTR_SKIP);
    $args['reply_text'] = 'Reply';
    $replayClass        = 'comment-depth-' . esc_attr($depth);
  ?>
    <li class="tj-comment" id="comment-<?php comment_ID(); ?>">
      <div class="comment-content">
        <?php if (get_avatar($comment)) : ?>
          <div class="comment-avatar">
            <?php echo get_avatar($comment, 102, null, null, ['class' => []]); ?>
          </div>
        <?php endif; ?>
        <div class="comments-header">
          <div class="avatar-name">
            <h6 class="title"><?php echo get_comment_author_link(); ?></h6>
          </div>
          <div class="comment-text">
            <span class="date"><?php comment_time(get_option('date_format')); ?></span>
            <div class="reply">
              <?php comment_reply_link(array_merge($args, ['depth' => $depth, 'max_depth' => $args['max_depth']])); ?>
            </div>
          </div>
          <div class="desc">
            <?php comment_text(); ?>
          </div>
        </div>
      </div>
  <?php
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * WP kses allowed tags
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('bexon_kses')) {
  function bexon_kses($raw) {

    $allowed_tags = array(
      'a'                             => array(
        'class'  => array(),
        'href'   => array(),
        'rel'    => array(),
        'title'  => array(),
        'target' => array(),
      ),
      'abbr'                          => array(
        'title' => array(),
      ),
      'b'                             => array(),
      'blockquote'                    => array(
        'cite' => array(),
      ),
      'cite'                          => array(
        'title' => array(),
      ),
      'code'                          => array(),
      'del'                           => array(
        'datetime' => array(),
        'title'    => array(),
      ),
      'dd'                            => array(),
      'div'                           => array(
        'class' => array(),
        'title' => array(),
        'style' => array(),
      ),
      'sub'                            => array(),
      'sup'                            => array(),
      'dl'                            => array(),
      'dt'                            => array(),
      'em'                            => array(),
      'h1'                            => array(),
      'h2'                            => array(),
      'h3'                            => array(),
      'h4'                            => array(),
      'h5'                            => array(),
      'h6'                            => array(),
      'i'                             => array(
        'class' => array(),
      ),
      'img'                           => array(
        'alt'    => array(),
        'class'  => array(),
        'height' => array(),
        'src'    => array(),
        'width'  => array(),
      ),
      'li'                            => array(
        'class' => array(),
      ),
      'ol'                            => array(
        'class' => array(),
      ),
      'p'                             => array(
        'class' => array(),
      ),
      'q'                             => array(
        'cite'  => array(),
        'title' => array(),
      ),
      'span'                          => array(
        'class' => array(),
        'title' => array(),
        'style' => array(),
      ),
      'iframe'                        => array(
        'width'       => array(),
        'height'      => array(),
        'scrolling'   => array(),
        'frameborder' => array(),
        'allow'       => array(),
        'src'         => array(),
      ),
      'strike'                        => array(),
      'br'                            => array(),
      'strong'                        => array(),
      'data-wow-duration'             => array(),
      'data-wow-delay'                => array(),
      'data-wallpaper-options'        => array(),
      'data-stellar-background-ratio' => array(),
      'ul'                            => array(
        'class' => array(),
      ),
      'svg'                           => array(
        'class'           => true,
        'aria-hidden'     => true,
        'aria-labelledby' => true,
        'role'            => true,
        'xmlns'           => true,
        'width'           => true,
        'height'          => true,
        'viewbox'         => true, // <= Must be lower case!
      ),
      'g'                             => array('fill' => true),
      'title'                         => array('title' => true),
      'path'                          => array('d' => true, 'fill' => true),
    );

    if (function_exists('wp_kses')) { // WP is here
      $allowed = wp_kses($raw, $allowed_tags);
    } else {
      $allowed = $raw;
    }

    return $allowed;
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Check if Elementor is activated
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('bexon_check_elementor_installed')) {

  function bexon_check_elementor_installed() {
    return did_action('elementor/loaded');
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Check if page build with elementor 
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('bexon_check_is_elementor')) {
  function bexon_check_is_elementor() {
    global $post;
    if (did_action('elementor/loaded')) {
      return \Elementor\Plugin::$instance->documents->get($post->ID)->is_built_with_elementor();
    }
    return false;
  }
}
