<?php

/**
 * Bexon TGM_Config
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

class TGM_Config
{

  public function __construct()
  {
    add_action('tgmpa_register', array($this, 'register_required_plugins'));
  }
  public function register_required_plugins()
  {
    $plugins = [
      // Bundled
      [
        'name'         => esc_html__('TJ Bexon Core', 'bexon'),
        'slug'         => 'tj-bexon-core',
        'required'     => true,
        'source'       => esc_url('https://themejunction.net/plugins/tj-bexon-core.zip'),
        'external_url' => esc_url('https://themejunction.net/plugins/tj-bexon-core.zip'),
      ],
      // Repository
      [
        'name'         => esc_html__('Advanced Custom Fields', 'bexon'),
        'slug'         => 'advanced-custom-fields',
        'required'     => true,
      ],
      [
        'name'     => esc_html__('Kirki', 'bexon'),
        'slug'     => 'kirki',
        'required' => true,
      ],
      [
        'name'     => esc_html__('Elementor', 'bexon'),
        'slug'     => 'elementor',
        'required' => true,
      ],
      [
        'name'     => esc_html__('Breadcrumb NavXT', 'bexon'),
        'slug'     => 'breadcrumb-navxt',
        'required' => true,
      ],
      [
        'name'     => esc_html__('Contact Form 7', 'bexon'),
        'slug'     => 'contact-form-7',
        'required' => false,
      ],
      [
        'name'     => esc_html__('One Click Demo Import', 'bexon'),
        'slug'     => 'one-click-demo-import',
        'required' => false,
      ],
      [
        'name'     => esc_html__('Classic Editor', 'bexon'),
        'slug'     => 'classic-editor',
        'required' => false,
      ],
      [
        'name'     => esc_html__('Classic Widgets', 'bexon'),
        'slug'     => 'classic-widgets',
        'required' => false,
      ],
      [
        'name'         => esc_html__('WooCommerce', 'bexon'),
        'slug'         => 'woocommerce',
        'required'     => false,
      ],
      [
        'name'         => esc_html__('WPC Smart Wishlist', 'bexon'),
        'slug'         => 'woo-smart-wishlist',
        'required'     => false,
      ],
      [
        'name'         => esc_html__('WPC Smart Quick View', 'bexon'),
        'slug'         => 'woo-smart-quick-view',
        'required'     => false,
      ],
      [
        'name'         => esc_html__('Polylang', 'bexon'),
        'slug'         => 'polylang',
        'required'     => false,
      ],
    ];

    $config = [
      'id'           => 'bexon',            // Unique ID for hashing notices for multiple instances of TGMPA.
      'default_path' => '',              // Default absolute path to bundled plugins.
      'menu'         => 'install-required-plugins', // Menu slug.
      'has_notices'  => true,                    // Show admin notices or not.
      'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
      'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
      'is_automatic' => false,                    // Automatically activate plugins after installation or not.
      'message'      => '',                      // Message to output right before the plugins table.
    ];

    tgmpa($plugins, $config);
  }
}
new TGM_Config;
