<?php

/**
 * Customizer Logos & Favicon
 *
 * style for theme logos & favicon
 */
$fields[] = [
  'type'     => 'custom',
  'settings' => 'logos_custom_01',
  'label'    => FALSE,
  'section'  => 'bexon_theme_logos',
  'default'  => '<div class="customizer_label">' . esc_html__('Site Logos', 'bexon') . '</div>',
  'description' => '<div class="alert alert-danger" role="alert">' . esc_html__('These options are only for the theme default footer which is not built with Elementor. Navigate to Dashboard -> Theme Builder to change the logos', 'bexon') . '</div>',
];

// primary logo
$fields[] = [
  'type'     => 'image',
  'settings' => 'primary_logo',
  'label'    => esc_html__('Primary Logo', 'bexon'),
  'section'  => 'bexon_theme_logos',
  'default'     => BEXON_ASSETS_IMAGES_URL . '/logos/primary-logo.webp',
];
$fields[] = [
  'type'     => 'dimensions',
  'settings' => 'primary_logo_dimension',
  'section'  => 'bexon_theme_logos',
  'transport'   => 'auto',
  'responsive' => true,
  'default'     => [
    'desktop' => [
      'max-width'  => '140px',
      'height' => 'auto',
    ],
    'tablet'  => [
      'max-width'  => '140px',
      'height' => 'auto',
    ],
    'mobile'  => [
      'max-width'  => '110px',
      'height' => 'auto',
    ],
  ],
  'choices'     => [
    'labels' => [
      'max-width'  => esc_html__('Max Width', 'bexon'),
      'height' => esc_html__('Height', 'bexon'),
    ],
  ],
  'output'      => [
    [
      'choice'   => 'max-width',
      'element'  => '.primary_logo',
      'property' => 'max-width',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
    [
      'choice'   => 'height',
      'element'  => '.primary_logo img',
      'property' => 'height',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
  ],
];

// Mobile logo
$fields[] = [
  'type'     => 'image',
  'settings' => 'mobile_logo',
  'label'    => esc_html__('Mobile Logo', 'bexon'),
  'section'  => 'bexon_theme_logos',
  'default'     => BEXON_ASSETS_IMAGES_URL . '/logos/secondary-logo.webp',
];
$fields[] = [
  'type'     => 'dimensions',
  'settings' => 'mobile_logo_dimension',
  'section'  => 'bexon_theme_logos',
  'transport'   => 'auto',
  'responsive' => true,
  'default'     => [
    'desktop' => [
      'max-width'  => '140px',
      'height' => 'auto',
    ],
    'tablet'  => [
      'max-width'  => '140px',
      'height' => 'auto',
    ],
    'mobile'  => [
      'max-width'  => '140px',
      'height' => 'auto',
    ],
  ],
  'choices'     => [
    'labels' => [
      'max-width'  => esc_html__('Max Width', 'bexon'),
      'height' => esc_html__('Height', 'bexon'),
    ],
  ],
  'output'      => [
    [
      'choice'   => 'max-width',
      'element'  => '.logo-area .mobile_logo',
      'property' => 'max-width',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
    [
      'choice'   => 'height',
      'element'  => '.logo-area .mobile_logo img',
      'property' => 'height',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
  ],
];
