<?php

/**
 * Customizer General Settings
 *
 * style for theme general settings
 */

$fields[] = [
    'type'     => 'custom',
    'settings' => 'general_custom_01',
    'label'    => FALSE,
    'section'  => 'general_settings',
    'default'  => '<div class="customizer_label">' . esc_html__('Back To Top', 'bexon') . '</div>',
];
// backToTop
$fields[] = [
    'type'     => 'toggle',
    'settings' => 'bexon_backtotop',
    'label'    => esc_html__('Show Back to Top', 'bexon'),
    'section'  => 'general_settings',
    'default'  => false,
];
//color
$fields[] = array(
    'type'            => 'color',
    'settings'        => 'backtop_icon_color',
    'label'           => esc_html__('Color', 'bexon'),
    'section'         => 'general_settings',
    'choices'         => [
        'alpha' => true,
    ],
    'transport'       => 'auto',
    'output'          => [
        [
            'element'  => '.back-to-top-btn span',
            'property' => 'color',
        ],
    ],
    'active_callback' => [
        [
            'setting'  => 'bexon_backtotop',
            'operator' => '==',
            'value'    => true,
        ],
    ],
);
// background color
$fields[] = array(
    'type'            => 'color',
    'settings'        => 'backtop_bg_color',
    'label'           => esc_html__('Background Color', 'bexon'),
    'section'         => 'general_settings',
    'choices'         => [
        'alpha' => true,
    ],
    'transport'       => 'auto',
    'output'          => [
        [
            'element'  => '.back-to-top-btn span',
            'property' => 'background-color',
        ],
    ],
    'active_callback' => [
        [
            'setting'  => 'bexon_backtotop',
            'operator' => '==',
            'value'    => true,
        ],
    ],
);

// preloader
$fields[] = [
    'type'     => 'custom',
    'settings' => 'general_custom_02',
    'label'    => FALSE,
    'section'  => 'general_settings',
    'default'  => '<div class="customizer_label">' . esc_html__('Preloader', 'bexon') . '</div>',
];
$fields[] = [
    'type'     => 'toggle',
    'settings' => 'show_preloader',
    'label'    => esc_html__('Show Preloader', 'bexon'),
    'section'  => 'general_settings',
    'default'  => false,
];

$fields[] = [
    'type'     => 'select',
    'label'    => 'Preloader Style',
    'settings' => 'select_preloader',
    'section'  => 'general_settings',
    'default'  => 'style-1',
    'choices'  => [
        'style-1' => esc_html__('Logo based loader', 'bexon'),
        'style-2' => esc_html__('Text based loader', 'bexon'),
    ],
    'active_callback' => [
        [
            'setting'  => 'show_preloader',
            'operator' => '==',
            'value'    => true,
        ],
    ],
];

$fields[] = [
    'type'     => 'text',
    'settings' => 'preloader_text',
    'label'    => esc_html__('Preloader Text', 'bexon'),
    'section'  => 'general_settings',
    'default'  => esc_html__('Loading...', 'bexon'),
    'active_callback' => [
        [
            'setting'  => 'select_preloader',
            'operator' => '==',
            'value'    => 'style-2',
        ],
    ],
];

$fields[] = [
    'type'        => 'image',
    'settings'    => 'preloader_logo',
    'label'       => esc_html__('Preloader Logo', 'bexon'),
    'section'     => 'general_settings',
    'default'     => BEXON_ASSETS_IMAGES_URL . '/logos/logo-icon.webp',
    'active_callback' => [
        [
            'setting'  => 'select_preloader',
            'operator' => '==',
            'value'    => 'style-1',
        ],
    ],
];
// background color
$fields[] = array(
    'type'            => 'color',
    'settings'        => 'loader_bg_color',
    'label'           => esc_html__('Loader BG Color', 'bexon'),
    'section'         => 'general_settings',
    'choices'         => [
        'alpha' => true,
    ],
    'transport'       => 'auto',
    'output'          => [
        [
            'element'  => '#loading::after',
            'property' => 'background-color',
        ],
    ],
    'active_callback' => [
        [
            'setting'  => 'select_preloader',
            'operator' => '==',
            'value'    => 'style-1',
        ],
    ],
);
// loader color
$fields[] = array(
    'type'            => 'color',
    'settings'        => 'loader_anim_color',
    'label'           => esc_html__('Loader Animation Color', 'bexon'),
    'section'         => 'general_settings',
    'choices'         => [
        'alpha' => true,
    ],
    'transport'       => 'auto',
    'output'          => [
        [
            'element'  => '#loading #loading-center #loading-center-absolute .object',
            'property' => 'border-left-color',
        ],
        [
            'element'  => '#loading #loading-center #loading-center-absolute .object',
            'property' => 'border-top-color',
        ],
    ],
    'active_callback' => [
        [
            'setting'  => 'select_preloader',
            'operator' => '==',
            'value'    => 'style-1',
        ],
    ],
);
$fields[] = array(
    'type'            => 'color',
    'settings'        => 'loader_ball_text_color',
    'label'           => esc_html__('Loader Text Color', 'bexon'),
    'section'         => 'general_settings',
    'choices'         => [
        'alpha' => true,
    ],
    'transport'       => 'auto',
    'output'          => [
        [
            'element'  => '.tj-preloader .tj-preloader-text',
            'property' => 'color',
        ],
    ],
    'active_callback' => [
        [
            'setting'  => 'select_preloader',
            'operator' => '==',
            'value'    => 'style-2',
        ],
    ],
);
$fields[] = array(
    'type'            => 'color',
    'settings'        => 'loader_ball_bg_color',
    'label'           => esc_html__('Loader Ball Color', 'bexon'),
    'section'         => 'general_settings',
    'choices'         => [
        'alpha' => true,
    ],
    'transport'       => 'auto',
    'output'          => [
        [
            'element'  => '.tj-preloader .tj-preloader-ball-inner, .tj-preloader .tj-preloader-ball',
            'property' => 'background-color',
        ],
    ],
    'active_callback' => [
        [
            'setting'  => 'select_preloader',
            'operator' => '==',
            'value'    => 'style-2',
        ],
    ],
);

$fields[] = array(
    'type'            => 'color',
    'settings'        => 'loader_text_bg_color',
    'label'           => esc_html__('Loader BG Color', 'bexon'),
    'section'         => 'general_settings',
    'choices'         => [
        'alpha' => true,
    ],
    'transport'       => 'auto',
    'output'          => [
        [
            'element'  => '.tj-preloader, .tj-preloader .tj-preloader-overlay',
            'property' => 'background-color',
        ],
    ],
    'active_callback' => [
        [
            'setting'  => 'select_preloader',
            'operator' => '==',
            'value'    => 'style-2',
        ],
    ],
);
