<?php

/**
 * Bexon Customizer Configuration
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

if (!defined('ABSPATH')) {
  exit;
}

// Do not proceed if Kirki does not exist.
if (!class_exists('Kirki')) {
  return;
}

class Bexon_Customizer
{

  public static $_instance;

  public function __construct()
  {
    add_action('customize_register', [$this, 'bexon_customizer_sections']);
    add_filter('kirki/fields', [$this, 'bexon_customizer_setting']);
    add_action('customize_preview_init', [$this, 'bexon_customize_preview_js']);
  }

  /**
   *    ---------------------------------------------------------------------------------------
   *    Customizer Sections
   *    ---------------------------------------------------------------------------------------
   */
  public function bexon_customizer_sections($wp_customize)
  {
    // Customizer Panel
    $wp_customize->add_panel('bexon_customizer_panel', [
      'priority' => 10,
      'title'    => esc_html__('Bexon Customizer', 'bexon'),
    ]);

    // general settings
    $wp_customize->add_section('general_settings', [
      'title'       => esc_html__('General Settings', 'bexon'),
      'priority'    => 1,
      'description' => esc_html__('To change site general settings', 'bexon'),
      'panel'       => 'bexon_customizer_panel',
    ]);

    // typography settings
    $wp_customize->add_section('typo_settings', [
      'title'       => esc_html__('Typography Settings', 'bexon'),
      'priority'    => 2,
      'description' => esc_html__('Setup site typography settings.', 'bexon'),
      'panel'       => 'bexon_customizer_panel',
    ]);

    // colors settings
    $wp_customize->add_section('colors_settings', [
      'title'       => esc_html__('Color Settings', 'bexon'),
      'priority'    => 3,
      'description' => esc_html__('Setup site color settings.', 'bexon'),
      'panel'       => 'bexon_customizer_panel',
    ]);

    // Logos
    $wp_customize->add_section('bexon_theme_logos', [
      'title'       => esc_html__('Site Logos', 'bexon'),
      'description' => esc_html__('Setup site logos.', 'bexon'),
      'priority'    => 4,
      'capability'  => 'edit_theme_options',
      'panel'       => 'bexon_customizer_panel',
    ]);

    // Contact Infos
    $wp_customize->add_section('bexon_contact_infos', [
      'title'       => esc_html__('Contact Info', 'bexon'),
      'description' => esc_html__('Setup site contact infos.', 'bexon'),
      'priority'    => 5,
      'panel'       => 'bexon_customizer_panel',
    ]);

    // header settings
    $wp_customize->add_section('header_settings', [
      'title'       => esc_html__('Header Settings', 'bexon'),
      'priority'    => 6,
      'description' => esc_html__('Setup site header settings.', 'bexon'),
      'panel'       => 'bexon_customizer_panel',
    ]);

    // Page header Settings
    $wp_customize->add_section('pageheader_setting', [
      'title'       => esc_html__('Page Header Setting', 'bexon'),
      'priority'    => 7,
      'description' => esc_html__('Setup site page header settings.', 'bexon'),
      'panel'       => 'bexon_customizer_panel',
    ]);

    // blog settings
    $wp_customize->add_section('blog_settings', [
      'title'       => esc_html__('Blog Settings', 'bexon'),
      'priority'    => 8,
      'description' => esc_html__('Setup blog pages settings.', 'bexon'),
      'panel'       => 'bexon_customizer_panel',
    ]);

    // Services settings
    $wp_customize->add_section('services_settings', [
      'title'       => esc_html__('Services Settings', 'bexon'),
      'priority'    => 9,
      'description' => esc_html__('Setup services pages settings.', 'bexon'),
      'panel'       => 'bexon_customizer_panel',
    ]);

    // Projects settings
    $wp_customize->add_section('projects_settings', [
      'title'       => esc_html__('Projects Settings', 'bexon'),
      'priority'    => 10,
      'description' => esc_html__('Setup projects pages settings.', 'bexon'),
      'panel'       => 'bexon_customizer_panel',
    ]);

    // footer settings
    $wp_customize->add_section('footer_settings', [
      'title'       => esc_html__('Footer Settings', 'bexon'),
      'priority'    => 12,
      'description' => esc_html__('Setup site footer settings.', 'bexon'),
      'panel'       => 'bexon_customizer_panel',
    ]);

    // permalink settings
    $wp_customize->add_section('permalink_settings', [
      'title'       => esc_html__('Permalink Settings', 'bexon'),
      'priority'    => 11,
      'description' => esc_html__('Setup site permalink settings.', 'bexon'),
      'panel'       => 'bexon_customizer_panel',
    ]);

    // 404 page settings
    $wp_customize->add_section('404_page', [
      'title'       => esc_html__('404 Page', 'bexon'),
      'priority'    => 12,
      'description' => esc_html__('Setup 404 page settings.', 'bexon'),
      'panel'       => 'bexon_customizer_panel',
    ]);
    if (class_exists('WooCommerce')) {
      // shop page settings
      $wp_customize->add_section('shop_page', [
        'title'       => esc_html__('Shop Page', 'bexon'),
        'priority'    => 13,
        'description' => esc_html__('Setup Shop page settings.', 'bexon'),
        'panel'       => 'bexon_customizer_panel',
      ]);
    }
  }

  /**
   *    ---------------------------------------------------------------------------------------
   *    Customizer Settings Fields
   *    ---------------------------------------------------------------------------------------
   */
  public function bexon_customizer_setting($fields)
  {

    require BEXON_CUSTOMIZER_DIR . 'fields/general-settings.php';
    require BEXON_CUSTOMIZER_DIR . 'fields/typography-settings.php';
    require BEXON_CUSTOMIZER_DIR . 'fields/colors-settings.php';
    require BEXON_CUSTOMIZER_DIR . 'fields/theme-logos.php';
    require BEXON_CUSTOMIZER_DIR . 'fields/header-settings.php';
    require BEXON_CUSTOMIZER_DIR . 'fields/pageheader-settings.php';
    require BEXON_CUSTOMIZER_DIR . 'fields/blog-settings.php';
    require BEXON_CUSTOMIZER_DIR . 'fields/projects-settings.php';
    require BEXON_CUSTOMIZER_DIR . 'fields/footer-settings.php';
    require BEXON_CUSTOMIZER_DIR . 'fields/permalink-settings.php';
    require BEXON_CUSTOMIZER_DIR . 'fields/404-settings.php';
    if (class_exists('WooCommerce')) {
      require BEXON_CUSTOMIZER_DIR . 'fields/shop-settings.php';
    }

    return $fields;
  }

  /**
   *    ---------------------------------------------------------------------------------------
   *    Customizer Preview JS
   *    ---------------------------------------------------------------------------------------
   */
  public function bexon_customize_preview_js()
  {
    wp_enqueue_script('bexon-customizer', BEXON_INC_URL . '/assets/js/customize-preview.js', array('customize-preview'), BEXON_THEME_VERSION, true);
  }

  public static function bexon_get_instance()
  {
    if (!isset(self::$_instance)) {
      self::$_instance = new Bexon_Customizer();
    }
    return self::$_instance;
  }
}
$bexon_Fields = Bexon_Customizer::bexon_get_instance();
