<?php

/**
 * Bexon Theme Widgets Register
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

if (!defined('ABSPATH')) {
  exit;
}

/**
 *    ---------------------------------------------------------------------------------------
 *    Register widget area.
 *    ---------------------------------------------------------------------------------------
 */

/**
 * blog sidebar
 */

register_sidebar([
  'name'          => esc_html__('Blog Sidebar', 'bexon'),
  'id'            => 'blog-sidebar',
  'before_widget' => '<div id="%1$s" class="tj-sidebar-widget %2$s">',
  'after_widget'  => '</div>',
  'before_title'  => '<h4 class="widget-title">',
  'after_title'   => '</h4>',
]);

$bexonFooterColumns = get_theme_mod('footer_widget_column', 4);

// footer default
for ($num = 1; $num <= $bexonFooterColumns; $num++) {
  register_sidebar([
    'name'          => sprintf(esc_html__('Footer Column %1$s', 'bexon'), $num),
    'id'            => 'footer-' . $num,
    'description'   => sprintf(esc_html__('This widget content will be show widget %1$s', 'bexon'), $num),
    'before_widget' => '<div id="%1$s" class="tj-footer-widget footer-widget footer-column-' . $num . ' %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<h5 class="title">',
    'after_title'   => '</h5>',
  ]);
}
