<?php

/**
 * Bexon Theme Scripts
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

if (!defined('ABSPATH')) {
  exit;
}


function bexon_scripts()
{
  /**
   * ---------------------------------------------------------------------------------------
   * Enqueue All CSS Files
   * ---------------------------------------------------------------------------------------
   */
  wp_enqueue_style('bexon-google-fonts', bexon_google_fonts_url(), '', null);

  if (is_rtl()) {
    wp_enqueue_style('bexon-bootstrap-rtl', BEXON_ASSETS_CSS_URL . 'bootstrap.rtl.min.css', []);
  } else {
    wp_enqueue_style('bexon-bootstrap', BEXON_ASSETS_CSS_URL . 'bootstrap.min.css', []);
  }
  wp_enqueue_style('bexon-font-awesome', BEXON_ASSETS_CSS_URL . 'font-awesome.min.css', []);
  wp_enqueue_style('bexon-animate', BEXON_ASSETS_CSS_URL . 'animate.min.css', []);
  wp_enqueue_style('bexon-select', BEXON_ASSETS_CSS_URL . 'nice-select.css', []);
  wp_enqueue_style('bexon-meanmenu', BEXON_ASSETS_CSS_URL . 'meanmenu.css', []);
  wp_enqueue_style('bexon-magnific', BEXON_ASSETS_CSS_URL . 'magnific-popup.css', []);
  wp_enqueue_style('bexon-swiper', BEXON_ASSETS_CSS_URL . 'swiper.min.css', []);
  wp_enqueue_style('bexon-icons', BEXON_ASSETS_CSS_URL . 'bexon-icons.css', []);
  wp_enqueue_style('bexon-unit', BEXON_ASSETS_CSS_URL . 'bexon-unit.css', [], BEXON_THEME_VERSION);
  wp_enqueue_style('bexon-core', BEXON_ASSETS_CSS_URL . 'bexon-core.css', [], BEXON_THEME_VERSION);

  if (class_exists('WooCommerce')) {
    wp_enqueue_style('bexon-shop', BEXON_ASSETS_CSS_URL . 'bexon-shop.css', [], BEXON_THEME_VERSION);
  }

  wp_enqueue_style('bexon-style', get_stylesheet_uri(), [], BEXON_THEME_VERSION);

  /**
   * ---------------------------------------------------------------------------------------
   * Enqueue All JS Files
   * ---------------------------------------------------------------------------------------
   */
  wp_enqueue_script('bexon-bootstrap', BEXON_ASSETS_JS_URL . 'bootstrap.min.js', ['jquery'], '', true);
  wp_enqueue_script('bexon-gsap', BEXON_ASSETS_JS_URL . 'gsap.min.js', ['jquery'], '', true);
  wp_enqueue_script('bexon-scroll-to-plugin', BEXON_ASSETS_JS_URL . 'scroll-to-plugin.min.js', ['jquery'], '', true);
  wp_enqueue_script('bexon-scroll-trigger', BEXON_ASSETS_JS_URL . 'scroll-trigger.min.js', ['jquery'], '', true);
  wp_enqueue_script('bexon-split-text', BEXON_ASSETS_JS_URL . 'split-text.min.js', ['jquery'], '', true);
  wp_enqueue_script('bexon-scroll-smooth', BEXON_ASSETS_JS_URL . 'smooth-scroll.min.js', ['jquery'], '', true);
  wp_enqueue_script('bexon-waypoints', BEXON_ASSETS_JS_URL . 'waypoints.min.js', ['jquery'], '', true);
  wp_enqueue_script('bexon-select', BEXON_ASSETS_JS_URL . 'nice-select.min.js', ['jquery'], '', true);
  wp_enqueue_script('bexon-counterup', BEXON_ASSETS_JS_URL . 'counterup.min.js', ['jquery'], '', true);
  wp_enqueue_script('bexon-swiper', BEXON_ASSETS_JS_URL . 'swiper.min.js', ['jquery'], '', true);
  wp_enqueue_script('bexon-magnific', BEXON_ASSETS_JS_URL . 'magnific-popup.min.js', ['jquery'], '', true);
  wp_enqueue_script('bexon-wow', BEXON_ASSETS_JS_URL . 'wow.min.js', ['jquery'], '', true);
  wp_enqueue_script('bexon-knob', BEXON_ASSETS_JS_URL . 'jquery-knob.js', ['jquery'], '', true);
  wp_enqueue_script('bexon-meanmenu', BEXON_ASSETS_JS_URL . 'meanmenu.js', ['jquery'], '', true);
  wp_enqueue_script('bexon-isotope', BEXON_ASSETS_JS_URL . 'isotope.pkgd.min.js', ['jquery', 'imagesloaded'], '', true);
  wp_enqueue_script('bexon-magiccursor', BEXON_ASSETS_JS_URL . 'magiccursor.js', ['jquery'], '', true);
  wp_enqueue_script('bexon-main', BEXON_ASSETS_JS_URL . 'bexon-main.js', ['jquery'], BEXON_THEME_VERSION, true);

  if (is_singular() && comments_open() && get_option('thread_comments')) {
    wp_enqueue_script('comment-reply');
  }
}
add_action('wp_enqueue_scripts', 'bexon_scripts', 5);

/**
 * ---------------------------------------------------------------------------------------
 * Register Google Fonts
 * ---------------------------------------------------------------------------------------
 */
function bexon_google_fonts_url()
{
  $fonts_url     = '';
  $font_families = [];

  $monaSans = _x('on', 'Mona Sans font: on or off', 'bexon');

  if ('off' !== $monaSans) {
    $font_families[] = 'Mona Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap';
  }

  if ($font_families) {
    $query_args = array(
      'family' => urlencode(implode('|', $font_families)),
      'subset' => urlencode('latin,latin-ext'),
    );
    $fonts_url = add_query_arg($query_args, '//fonts.googleapis.com/css');
  }

  return $fonts_url;
}
