<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<?php if (is_singular() && pings_open(get_queried_object())) : ?>
	<?php endif; ?>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php wp_body_open(); ?>

	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'bexon'); ?></a>

	<!-- start: Header Style -->
	<?php if (! function_exists('elementor_theme_do_location') || ! elementor_theme_do_location('header')) {
		get_template_part('template-parts/header/default');
	} ?>
	<!-- end: Header Style -->

	<?php
	/**
	 * Hook: ts_before_main_content.
	 *
	 * Before the main content wrapper starts.
	 */
	do_action('tj_before_main_content'); ?>

	<?php
	/**
	 * Hook: tj_page_header.
	 *
	 * Page header content, like breadcrumbs or titles.
	 */
	do_action('tj_page_header'); ?>

	<main id="content" class="site-main">