<?php

/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if (post_password_required()) {
	return;
}
?>

<?php if (have_comments() || comments_open()) : ?>

	<!-- post comment -->
	<div id="comments" class="tj-comments-container">

		<?php if (get_comments_number() >= 1) : ?>
			<div class="tj-comments-wrap">
				<?php
				$comment_no = number_format_i18n(get_comments_number());
				$comment_text = (!empty($comment_no) and ($comment_no > 1)) ? esc_html__(' Comments', 'bexon') : esc_html__(' Comment ', 'bexon');
				$comment_no = (!empty($comment_no) and ($comment_no > 0)) ? '<h3 class="comment-title">' . esc_html($comment_no . $comment_text) . '</h3>' : ' ';
				print sprintf("%s", $comment_no);
				?>

				<div class="tj-latest-comments">
					<ul>
						<?php
						wp_list_comments([
							'style'       => 'ul',
							'callback'    => 'bexon_comment',
							'avatar_size' => 120,
							'short_ping'  => true,
						]);
						?>
					</ul>
				</div>
			</div>
		<?php endif; ?>

		<?php if (get_comment_pages_count() > 1 && get_option('page_comments')) : ?>
			<div class="tj-comment-pagination">
				<nav id="comment-nav-below" class="comment-navigation" role="navigation">
					<h1 class="screen-reader-text"><?php esc_html_e('Comment navigation', 'bexon'); ?></h1>
					<div class="row">
						<div class="col-md-6">
							<div class="nav-previous "><?php previous_comments_link(esc_html__('&larr; Older ', 'bexon')); ?></div>
						</div>
						<div class="col-md-6">
							<div class="nav-next "><?php next_comments_link(esc_html__('Newer &rarr;', 'bexon')); ?></div>
						</div>
					</div>
					<div class="clearfix"></div>
				</nav><!-- #comment-nav-below -->
			</div>
		<?php endif; // check for comment navigation 
		?>

		<?php
		$post_id = '';
		if (null === $post_id)
			$post_id = get_the_ID();
		else
			$id      = $post_id;

		$commenter       = wp_get_current_commenter();
		$user            = wp_get_current_user();
		$user_identity   = $user->exists() ? $user->display_name : '';


		$req         = get_option('require_name_email');
		$aria_req    = ($req ? " aria-required='true'" : '');

		$fields = array(
			'author' => '<div class="row"><div class="col-lg-4"><div class="form-input"><input placeholder="' .  esc_attr__('Enter Name', 'bexon') . '" id="author" class="tj-form-control" name="author" type="text" value="' . esc_attr($commenter['comment_author']) . '" size="30"' . $aria_req . ' /></div></div>',
			'email'  => '<div class="col-lg-4"><div class="form-input"><input placeholder="' .  esc_attr__('Enter Email', 'bexon') . '" id="email" name="email" class="tj-form-control" type="email" value="' . esc_attr($commenter['comment_author_email']) . '" size="30"' . $aria_req . ' /></div></div>',
			'url'    => '<div class="col-lg-4"><div class="form-input"><input placeholder="' .  esc_attr__('Enter Website', 'bexon') . '" id="url" name="url" class="tj-form-control" type="url" value="' . esc_attr($commenter['comment_author_url']) . '" size="30" /></div></div></div>'
		);

		if (is_user_logged_in()) {
			$cl = 'loginformuser';
		} else {
			$cl = '';
		}
		$defaults = [
			'fields'             => $fields,
			'comment_field'      => '
            <div class="row">
                <div class="col-lg-12 ' . $cl . '">
                    <div class="form-input"><textarea class="tj-form-control msg-box" placeholder="' .  esc_attr__('Enter Your Comments', 'bexon') . '" id="comment" name="comment" cols="45" rows="8" aria-required="true"></textarea></div>
				</div>
            </div>',
			'submit_button'    => '<button class="tj-primary-btn submit" type="submit"><span class="btn-text"><span>' . esc_html__('Post Comment', 'bexon') . '</span></span><span class="btn-icon"><i class="tji-arrow-right-long"></i></span></button>',
			/** This filter is documented in wp-includes/link-template.php */
			'must_log_in'        => '
            <p class="must-log-in">
            ' . esc_html__('You must be', 'bexon') . ' <a href="' . esc_url(wp_login_url(apply_filters('the_permalink', get_permalink($post_id)))) . '">' . esc_html__('logged in', 'bexon') . '</a> ' . esc_html__('to post a comment.', 'bexon') . '
            </p>',
			/** This filter is documented in wp-includes/link-template.php */
			'logged_in_as'       => '
            <p class="logged-in-as">
            ' . esc_html__('Logged in as', 'bexon') . ' <a href="' . esc_url(get_edit_user_link()) . '">' . esc_html($user_identity) . '</a>. <a href="' . esc_url(wp_logout_url(apply_filters('the_permalink', get_permalink($post_id)))) . '" title="' . esc_attr__('Log out of this account', 'bexon') . '">' . esc_html__('Log out?', 'bexon') . '</a>
            </p>',
			'id_form'            => 'commentForm',
			'class_form'         => 'tj-post-comment-form',
			'title_reply'        => esc_html__('Leave a Comment', 'bexon'),
			'title_reply_to'     => esc_html__('Leave a Comment to %s', 'bexon'),
			'label_submit'       => esc_html__('Post Comment', 'bexon'),
			'format'             => 'xhtml',
		];

		comment_form($defaults);
		?>

	</div><!-- #comments -->
<?php endif; ?>