<?php

/**
 * TJ Recent Posts
 *
 *
 * @author 		Theme_Junction
 * @category 	Widgets
 * @package 	TJCore/Widgets
 * @version 	1.0.0
 * @extends 	WP_Widget
 */
if (!defined('ABSPATH')) {
  die('Direct access forbidden.');
}


/**
 * Adds TJ_Recent_Post_Widget
 */
add_action('widgets_init', 'TJ_Recent_Post_Widget');
function TJ_Recent_Post_Widget()
{
  register_widget('TJ_Recent_Post_Widget');
}

/**
 * Class TJ_Recent_Post_Widget
 */
class TJ_Recent_Post_Widget extends WP_Widget
{

  /**
   * Widget Constructor
   */
  public function __construct()
  {
    $widget_opt = array(
      'classname'     => 'tj_recent_posts',
      'description'   => 'Recent posts widget by Theme Junction'
    );
    parent::__construct('tj-recent-posts', esc_html__('TJ Recent Posts', 'tjcore'), $widget_opt);
  }


  /**
   * Front-end display of widget.
   */
  public function widget($args, $instance)
  {
    extract($args);
    extract($instance);

    echo $before_widget;
    if ($instance['title']) :
      echo $before_title; ?>
      <?php echo apply_filters('widget_title', $instance['title']); ?>
      <?php echo $after_title; ?>
    <?php endif; ?>

    <?php
    $q = new WP_Query(array(
      'post_type'     => 'post',
      'posts_per_page' => ($instance['count']) ? $instance['count'] : '2',
      'order'      => ($instance['posts_order']) ? $instance['posts_order'] : 'DESC',
      'orderby' => 'date',
      // 'post__not_in' => [get_the_ID()],
    ));
    ?>

    <?php if ($q->have_posts()) : ?>
      <ul>

        <?php while ($q->have_posts()) : $q->the_post(); ?>
          <li>
            <?php if (has_post_thumbnail()) : ?>
              <div class="post-thumb">
                <a href="<?php the_permalink(); ?>">
                  <?php the_post_thumbnail('thumbnail'); ?>
                </a>
              </div>
            <?php endif; ?>

            <div class="post-content">
              <h6 class="post-title">
                <a href="<?php the_permalink(); ?>"><?php echo wp_trim_words(get_the_title(), 6, '...'); ?></a>
              </h6>
              <div class="post-meta">
                <ul>
                  <li>
                    <?php the_time('d M, Y'); ?>
                  </li>
                </ul>
              </div>
            </div>
          </li>

        <?php endwhile; ?>

      </ul>
    <?php endif; ?>

    <?php echo $after_widget; ?>

  <?php
  }


  /**
   * Back-end widget form.
   */
  public function form($instance)
  {
    $title = !empty($instance['title']) ? $instance['title'] : '';
    $count = !empty($instance['count']) ? $instance['count'] : esc_html__('3', 'tjcore');
    $posts_order = !empty($instance['posts_order']) ? $instance['posts_order'] : esc_html__('DESC', 'tjcore');
  ?>
    <p>
      <label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title', 'tjcore'); ?></label>
      <input type="text" name="<?php echo $this->get_field_name('title'); ?>" id="<?php echo $this->get_field_id('title'); ?>" value="<?php echo esc_attr($title); ?>" class="widefat">
    </p>

    <p>
      <label for="<?php echo $this->get_field_id('count'); ?>"><?php esc_html_e('How many posts you want to show ?', 'tjcore'); ?></label>
      <input type="number" name="<?php echo $this->get_field_name('count'); ?>" id="<?php echo $this->get_field_id('count'); ?>" value="<?php echo esc_attr($count); ?>" class="widefat">
    </p>

    <p>
      <label for="<?php echo $this->get_field_id('posts_order'); ?>"><?php esc_html_e('Posts Order', 'tjcore') ?></label>
      <select name="<?php echo $this->get_field_name('posts_order'); ?>" id="<?php echo $this->get_field_id('posts_order'); ?>" class="widefat">
        <option value="" disabled="disabled"><?php esc_html_e('Select Post Order', 'tjcore'); ?></option>
        <option value="ASC" <?php if ($posts_order === 'ASC') {
                              echo 'selected="selected"';
                            } ?>><?php esc_html_e('ASC', 'tjcore'); ?></option>
        <option value="DESC" <?php if ($posts_order === 'DESC') {
                                echo 'selected="selected"';
                              } ?>><?php esc_html_e('DESC', 'tjcore'); ?></option>
      </select>
    </p>

<?php }
}
