<?php

/**
 * TJ Category Widgets
 *
 *
 * @author 		ThemeJunction 
 * @package 	TJCore/Widgets
 * @version 	1.0.0
 */
if (!defined('ABSPATH')) {
    die('Direct access forbidden.');
}


/**
 * Adds TJ_Category_Widget
 */
add_action('widgets_init', 'TJ_Category_Widget');
function TJ_Category_Widget()
{
    register_widget('TJ_Category_Widget');
}

/**
 * Class TJ_Category_Widget
 */
class TJ_Category_Widget extends WP_Widget
{

    /**
     * Widget Constructor
     */
    public function __construct()
    {
        $widget_opt = array(
            'classname'     => 'tj_category_widget',
            'description'   => 'Category widget by Theme Junction'
        );
        parent::__construct('tj-category-widget', esc_html__('TJ Category Widget', 'tjcore'), $widget_opt);
    }


    /**
     * Front-end display of widget.
     */
    function widget($args, $instance)
    {
        extract($args);
        extract($instance);

        echo $before_widget;

        $title = (isset($instance['title']) && $instance['title'] != '') ? $instance['title'] : esc_html__('All Catagory', 'tjcore');
        $number = (isset($instance['number']) && !empty($instance['number'])) ? $instance['number'] : 4;
        $orderby = (isset($instance['orderby']) && !empty($instance['orderby'])) ? $instance['orderby'] : 'name';
        $order = (isset($instance['order']) && !empty($instance['order'])) ? $instance['order'] : 'ASC';
        $hide_empty = (isset($instance['hide_empty']) && $instance['hide_empty'] > 0) ? $instance['hide_empty'] : 0;



        if (!empty($title)) {
            echo $before_title . apply_filters('widget_title', $title) . $after_title;
        }

        $args = array(
            'taxonomy'              => 'category',
            'number'                => $number,
            'orderby'               => $orderby,
            'order'                 => $order,
            'hide_empty'            => $hide_empty,
        );

        $categories = get_categories($args);
?>
        <?php if (!empty($categories)) : ?>
            <ul>
                <?php foreach ($categories as $cat) : ?>
                    <li>
                        <a href="<?php echo get_category_link($cat->term_id); ?>">
                            <?php echo esc_html($cat->name) ?>
                            <span class="number">(<?php echo esc_html($cat->count) ?>)</span>
                        </a>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>

        <?php echo $after_widget; ?>
    <?php
    }


    /**
     * Back-end widget form.
     */
    function form($instance)
    {
        $title = (isset($instance['title']) && $instance['title'] != '') ? $instance['title'] : esc_html__('All Catagory', 'tjcore');
        $number = (isset($instance['number']) && !empty($instance['number'])) ? $instance['number'] : 4;
        $orderby = (isset($instance['orderby']) && !empty($instance['orderby'])) ? $instance['orderby'] : 'name';
        $order = (isset($instance['order']) && !empty($instance['order'])) ? $instance['order'] : 'ASC';
        $hide_empty = (isset($instance['hide_empty']) && !empty($instance['hide_empty'])) ? $instance['hide_empty'] : 0;

    ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php _e('Title:', 'tjcore'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php _e('Number of Item:', 'tjcore'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="number" value="<?php echo esc_attr($number); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('orderby')); ?>"><?php _e('Order By:', 'tjcore'); ?></label>
            <select class="widefat" id="<?php echo esc_attr($this->get_field_id('orderby')); ?>" name="<?php echo esc_attr($this->get_field_name('orderby')); ?>">
                <option value="name" <?php if ($orderby == 'name') {
                                            echo 'selected="selected"';
                                        } ?>><?php echo esc_html__('Name', 'tjcore'); ?></option>
                <option value="term_id" <?php if ($orderby == 'term_id') {
                                            echo 'selected="selected"';
                                        } ?>><?php echo esc_html__('ID', 'tjcore'); ?></option>
                <option value="count" <?php if ($orderby == 'count') {
                                            echo 'selected="selected"';
                                        } ?>><?php echo esc_html__('Count', 'tjcore'); ?></option>
                <option value="include" <?php if ($orderby == 'include') {
                                            echo 'selected="selected"';
                                        } ?>><?php echo esc_html__('Include', 'tjcore'); ?></option>
            </select>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('order')); ?>"><?php _e('Order:', 'tjcore'); ?></label>
            <select class="widefat" id="<?php echo esc_attr($this->get_field_id('order')); ?>" name="<?php echo esc_attr($this->get_field_name('order')); ?>">
                <option value="ASC" <?php if ($order == 'ASC') {
                                        echo 'selected="selected"';
                                    } ?>><?php echo esc_html__('Ascending', 'tjcore'); ?></option>
                <option value="DESC" <?php if ($order == 'DESC') {
                                            echo 'selected="selected"';
                                        } ?>><?php echo esc_html__('Descending', 'tjcore'); ?></option>
            </select>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('hide_empty')); ?>"><?php _e('Hide Empty:', 'tjcore'); ?></label>
            <input <?php echo ($hide_empty == 1 ? ' checked="checked" ' : '') ?> id="<?php echo esc_attr($this->get_field_id('hide_empty')); ?>" name="<?php echo esc_attr($this->get_field_name('hide_empty')); ?>" type="checkbox" value="1" />
        </p>
<?php
    }

    /**
     * Sanitize widget form values as they are saved.
     */
    function update($new_instance, $old_instance)
    {
        return $new_instance;
    }
}
