<?php

/** 
 * This template for projects category
 *
 * @package  Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

if (!defined('ABSPATH')) {
  die('Direct access forbidden.');
}

get_header();

$showProjects = get_theme_mod('show_projects_item', -1);

$category = get_queried_object();

$args = array(
  'post_type' => 'projects',
  'post_status' => 'publish',
  'posts_per_page' => $showProjects,
  'order' => 'DESC',
  'tax_query' => array(
    array(
      'taxonomy' => 'projects-cat',
      'field'    => 'id',
      'terms'    => $category->term_id,
    ),
  ),
);

// The Query
$query = new \WP_Query($args);
?>

<section class="tj-project-page section-gap">
  <div class="container">
    <?php if ($query->have_posts()) : ?>
      <div class="row row-gap-4">

        <?php while ($query->have_posts()) : $query->the_post();

          $categories = get_the_terms(get_the_ID(), 'projects-cat');
        ?>
          <div class="col-xl-4 col-md-6">
            <div class="project-item wow fadeInUp" data-wow-delay="0.2s">
              <?php if (has_post_thumbnail()): ?>
                <div class="project-image">
                  <a href="<?php the_permalink(); ?>">
                    <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
                  </a>
                </div>
              <?php endif; ?>
              <div class="project-content">
                <?php if (!empty($categories)): ?>
                  <span class="categories">
                    <?php
                    $category_names = array();
                    foreach ($categories as $cat) {
                      $category_names[] = '<a href="' . esc_url(get_category_link($cat->term_id)) . '">' . esc_html($cat->name) . '</a>';
                    }
                    echo implode(' ', $category_names);
                    ?>
                  </span>
                <?php endif; ?>
                <div class="project-text">
                  <h4 class="title"><a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a></h4>

                  <a class="project-btn" href="<?php the_permalink(); ?>">
                    <i class="tji-arrow-right-big"></i>
                  </a>

                </div>
              </div>
            </div>
          </div>
        <?php endwhile;
        wp_reset_query(); ?>

      </div>
    <?php else :
      printf("%s", esc_html__("No projects available!", 'tjcore'));
    endif; ?>
  </div>
</section>

<?php get_footer(); ?>