<?php

/** 
 * This template for services archive
 *
 * @package TJCore/CustomPost
 * @author  Theme Junction 
 * @since   1.0.0
 */
if (!defined('ABSPATH')) {
  die('Direct access forbidden.');
}

get_header();

if (!function_exists('elementor_theme_do_location') || !elementor_theme_do_location('archive')) {

  $showServices = get_theme_mod('show_services_item', -1);
  $serviceButtonText = get_theme_mod('services_button_text', esc_html__("Read more", 'tjcore'));

  $args = array(
    'post_type' => 'services',
    'post_status' => 'publish',
    'posts_per_page' => $showServices,
    'order' => 'DESC',
  );

  $query = new \WP_Query($args);

  $service_excerpt = get_theme_mod('service_excerpt', true);

?>
  <!-- start: Services Area -->
  <section class="tj-services-page section-space">

    <div class="container">
      <?php if ($query->have_posts()) : ?>
        <div class="row rg-30 justify-content-center">
          <?php while ($query->have_posts()) : $query->the_post();

            $serviceIconType = function_exists('get_field') ? get_field("service_icon_type", get_the_ID()) : '';
            $serviceIcon = function_exists('get_field') ? get_field("service_icon", get_the_ID()) : '';
            $serviceFontAwesomeIcon = function_exists('get_field') ? get_field("service_fontawesome_icon", get_the_ID()) : '';
            $serviceImageIcon = function_exists('get_field') ? get_field("service_image_icon", get_the_ID()) : '';
            $serviceNumber = function_exists('get_field') ? get_field("service_number", get_the_ID()) : '';
          ?>
            <div class="col-lg-4 col-md-6">
              <div class="service-style-2 wow fadeInUp" data-wow-delay="0.1s">
                <div class="service-icon">
                  <?php if ('image-icon' === $serviceIconType && !empty($serviceImageIcon)) : ?>
                    <img src="<?php echo esc_url($serviceImageIcon['url']); ?>" alt="<?php echo esc_attr($serviceImageIcon['alt']); ?>">
                  <?php
                  elseif ('fontawesome-icon' === $serviceIconType && !empty($serviceFontAwesomeIcon)) :
                    echo bexon_kses($serviceFontAwesomeIcon);
                  elseif (!empty($serviceIcon)) : ?>
                    <i class="<?php echo esc_attr($serviceIcon); ?>"></i>
                  <?php endif; ?>
                </div>
                <div class="service-content">
                  <?php if (!empty($serviceNumber)) : ?>
                    <span class="number"><?php echo bexon_kses($serviceNumber); ?></span>
                  <?php endif; ?>
                  <h4 class="title"> <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>

                  <?php if (get_the_excerpt() && !empty($service_excerpt)): ?>
                    <!-- excerpt -->
                    <div class="desc">
                      <?php echo wp_trim_words(get_the_excerpt(), '15', '...'); ?>
                    </div>
                  <?php endif; ?>
                  <?php if (!empty($serviceButtonText)): ?>
                    <a class="service-button text-btn" href="<?php the_permalink(); ?>">
                      <?php echo esc_html($serviceButtonText); ?> <i class="tji-arrow-right"></i>
                    </a>
                  <?php endif; ?>
                </div>
                <?php if (has_post_thumbnail()): ?>
                  <div class="thumb">
                    <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          <?php endwhile;
          wp_reset_query(); ?>
        </div>
      <?php else :
        printf("%s", esc_html__("No services available!", 'tjcore'));
      endif; ?>
    </div>
  </section>
  <!-- end: Services Area -->

<?php
}
get_footer();
