<?php

/**
 * TJ Helper Functions
 *
 *
 * @author   ThemeJunction 
 * @package  TJCore
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
  die('Direct access forbidden.');
}

/** ---------------------------------------------------------------
 * Get All Pages
 *---------------------------------------------------------------*/
if (!function_exists('tj_get_all_pages')) {
  function tj_get_all_pages() {

    $page_list = get_posts(array(
      'post_type'      => 'page',
      'orderby'        => 'date',
      'order'          => 'DESC',
      'posts_per_page' => -1,
    ));

    $pages = array();

    if (!empty($page_list) && !is_wp_error($page_list)) {
      foreach ($page_list as $page) {
        $pages[$page->ID] = $page->post_title;
      }
    }

    return $pages;
  }
}

/** ---------------------------------------------------------------
 * Get Post Types
 *---------------------------------------------------------------*/
if (!function_exists('tj_get_post_types')) {
  function tj_get_post_types() {

    $tj_cptj         = get_post_types(['public' => true, 'show_in_nav_menus' => true], 'object');
    $tj_exclude_cpts = ['elementor_library', 'attachment'];
    foreach ($tj_exclude_cpts as $exclude_cpt) {
      unset($tj_cpts[$exclude_cpt]);
    }
    $post_types = array_merge($tj_cpts);
    foreach ($post_types as $type) {
      $types[$type->name] = $type->label;
    }
    return $types;
  }
}

/** ---------------------------------------------------------------
 * Get All Types Post
 *---------------------------------------------------------------*/
if (!function_exists('tj_get_all_types_post')) {
  function tj_get_all_types_post($post_type) {

    $posts_args = get_posts(array(
      'post_type'      => $post_type,
      'orderby'        => 'date',
      'order'          => 'DESC',
      'post_status'    => 'publish',
      'posts_per_page' => -1,
    ));

    $posts = [];

    if (!empty($posts_args) && !is_wp_error($posts_args)) {
      foreach ($posts_args as $post) {
        $posts[$post->ID] = $post->post_title;
      }
    }

    return $posts;
  }
}

/** ---------------------------------------------------------------
 * Get Thumbnail Sizes
 *---------------------------------------------------------------*/
if (!function_exists('tj_get_thumbnail_sizes')) {
  function tj_get_thumbnail_sizes() {
    $sizes = get_intermediate_image_sizes();
    foreach ($sizes as $s) {
      $ret[$s] = $s;
    }
    return $ret;
  }
}

/** ---------------------------------------------------------------
 * Get Order By Options
 *---------------------------------------------------------------*/
if (!function_exists('tj_get_orderby_options')) {
  function tj_get_orderby_options() {
    $orderby = array(
      'ID'            => 'Post ID',
      'author'        => 'Post Author',
      'title'         => 'Title',
      'date'          => 'Date',
      'modified'      => 'Last Modified Date',
      'parent'        => 'Parent Id',
      'rand'          => 'Random',
      'comment_count' => 'Comment Count',
      'menu_order'    => 'Menu Order',
    );
    return $orderby;
  }
}

/** ---------------------------------------------------------------
 * Get Categories
 *---------------------------------------------------------------*/
if (!function_exists('tj_get_categories')) {
  function tj_get_categories($taxonomy) {
    $terms = get_terms(array(
      'taxonomy'   => $taxonomy,
      'hide_empty' => true,
    ));
    $options = array();
    if (!empty($terms) && !is_wp_error($terms)) {
      foreach ($terms as $term) {
        $options[$term->slug] = $term->name;
      }
    }
    return $options;
  }
}

/**
 * Get all types of post.
 */
function get_post_list($post_type = 'any') {
  return get_query_post_list($post_type);
}


/**
 * @param string $post_type
 * @param int $limit
 * @param string $search
 * @return array
 */
function get_query_post_list($post_type = 'any', $limit = -1, $search = '') {
  global $wpdb;
  $where = '';
  $data = [];

  if (-1 == $limit) {
    $limit = '';
  } elseif (0 == $limit) {
    $limit = "limit 0,1";
  } else {
    $limit = $wpdb->prepare(" limit 0,%d", esc_sql($limit));
  }

  if ('any' === $post_type) {
    $in_search_post_types = get_post_types(['exclude_from_search' => false]);
    if (empty($in_search_post_types)) {
      $where .= ' AND 1=0 ';
    } else {
      $where .= " AND {$wpdb->posts}.post_type IN ('" . join(
        "', '",
        array_map('esc_sql', $in_search_post_types)
      ) . "')";
    }
  } elseif (!empty($post_type)) {
    $where .= $wpdb->prepare(" AND {$wpdb->posts}.post_type = %s", esc_sql($post_type));
  }

  if (!empty($search)) {
    $where .= $wpdb->prepare(" AND {$wpdb->posts}.post_title LIKE %s", '%' . esc_sql($search) . '%');
  }

  $query = "select post_title,ID  from $wpdb->posts where post_status = 'publish' $where $limit";
  $results = $wpdb->get_results($query);
  if (!empty($results)) {
    foreach ($results as $row) {
      $data[$row->ID] = $row->post_title;
    }
  }
  return $data;
}
/** ---------------------------------------------------------------
 * Get Elementor Templates
 *---------------------------------------------------------------*/
if (!function_exists('get_elementor_templates')) {
  function get_elementor_templates($type = null) {
    $options = [];

    if ($type) {
      $args = [
        'post_type'      => 'elementor_library',
        'posts_per_page' => -1,
      ];
      $args['tax_query'] = [
        [
          'taxonomy' => 'elementor_library_type',
          'field'    => 'slug',
          'terms'    => $type,
        ],
      ];

      $page_templates = get_posts($args);

      if (!empty($page_templates) && !is_wp_error($page_templates)) {
        foreach ($page_templates as $post) {
          $options[$post->ID] = $post->post_title;
        }
      }
    } else {
      $options = get_query_post_list('elementor_library');
    }

    return $options;
  }
}

/** ---------------------------------------------------------------
 * TJ Render Icon
 *---------------------------------------------------------------*/
if (!function_exists('tj_is_elementor_version')) {
  function tj_is_elementor_version($operator = '<', $version = '2.6.0') {
    return defined('ELEMENTOR_VERSION') && version_compare(ELEMENTOR_VERSION, $version, $operator);
  }
}
if (!function_exists('tj_render_icon')) {
  function tj_render_icon($settings = [], $old_icon_id = 'icon', $new_icon_id = 'selected_icon', $attributes = []) {
    // Check if its already migrated
    $migrated = isset($settings['__fa4_migrated'][$new_icon_id]);
    // Check if its a new widget without previously selected icon using the old Icon control
    $is_new = empty($settings[$old_icon_id]);

    $attributes['aria-hidden'] = 'true';

    if (tj_is_elementor_version('>=', '2.6.0') && ($is_new || $migrated)) {
      \Elementor\Icons_Manager::render_icon($settings[$new_icon_id], $attributes);
    } else {
      if (empty($attributes['class'])) {
        $attributes['class'] = $settings[$old_icon_id];
      } else {
        if (is_array($attributes['class'])) {
          $attributes['class'][] = $settings[$old_icon_id];
        } else {
          $attributes['class'] .= ' ' . $settings[$old_icon_id];
        }
      }
      printf('<i %s></i>', \Elementor\Utils::render_html_attributes($attributes));
    }
  }
}

/** ---------------------------------------------------------------
 * TJ kses Allowed Tags
 *---------------------------------------------------------------*/
function tj_kses($raw) {

  $allowed_tags = array(
    'a'                             => array(
      'class'  => array(),
      'href'   => array(),
      'rel'    => array(),
      'title'  => array(),
      'target' => array(),
    ),
    'abbr'                          => array(
      'title' => array(),
    ),
    'b'                             => array(),
    'blockquote'                    => array(
      'cite' => array(),
    ),
    'cite'                          => array(
      'title' => array(),
    ),
    'code'                          => array(),
    'del'                           => array(
      'datetime' => array(),
      'title'    => array(),
    ),
    'dd'                            => array(),
    'div'                           => array(
      'class' => array(),
      'title' => array(),
      'style' => array(),
    ),
    'sub'                            => array(),
    'sup'                            => array(),
    'dl'                            => array(),
    'dt'                            => array(),
    'em'                            => array(),
    'h1'                            => array(),
    'h2'                            => array(),
    'h3'                            => array(),
    'h4'                            => array(),
    'h5'                            => array(),
    'h6'                            => array(),
    'i'                             => array(
      'class' => array(),
    ),
    'img'                           => array(
      'alt'    => array(),
      'class'  => array(),
      'height' => array(),
      'src'    => array(),
      'width'  => array(),
    ),
    'li'                            => array(
      'class' => array(),
    ),
    'ol'                            => array(
      'class' => array(),
    ),
    'p'                             => array(
      'class' => array(),
    ),
    'q'                             => array(
      'cite'  => array(),
      'title' => array(),
    ),
    'span'                          => array(
      'class' => array(),
      'title' => array(),
      'style' => array(),
    ),
    'iframe'                        => array(
      'width'       => array(),
      'height'      => array(),
      'scrolling'   => array(),
      'frameborder' => array(),
      'allow'       => array(),
      'src'         => array(),
    ),
    'strike'                        => array(),
    'br'                            => array(),
    'strong'                        => array(),
    'data-wow-duration'             => array(),
    'data-wow-delay'                => array(),
    'data-wallpaper-options'        => array(),
    'data-stellar-background-ratio' => array(),
    'ul'                            => array(
      'class' => array(),
    ),
  );

  if (function_exists('wp_kses')) { // WP is here
    $allowed = wp_kses($raw, $allowed_tags);
  } else {
    $allowed = $raw;
  }

  return $allowed;
}

/** ---------------------------------------------------------------
 * Get Allowed HTML Tags.
 * Allowed levels are basic, intermediate and advance
 *---------------------------------------------------------------*/
function tj_get_allowed_html_desc($level = 'basic') {
  if (!in_array($level, ['basic', 'intermediate', 'advance'])) {
    $level = 'basic';
  }

  $tags_str = '<' . implode('>,<', array_keys(tj_get_allowed_html_tags($level))) . '>';
  return sprintf(__('This input field has support for the following HTML tags: %1$s', 'tjcore'), '<code>' . esc_html($tags_str) . '</code>');
}

// Get a list of all the allowed html tags.
function tj_get_allowed_html_tags($level = 'basic') {
  $allowed_html = [
    'b'      => [],
    'i'      => [
      'class' => [],
    ],
    'u'      => [],
    'em'     => [],
    'br'     => [],
    'abbr'   => [
      'title' => [],
    ],
    'span'   => [
      'class' => [],
    ],
    'strong' => [],
  ];

  if ($level === 'intermediate') {
    $allowed_html['a'] = [
      'href'   => [],
      'title'  => [],
      'class'  => [],
      'id'     => [],
      'target' => [],
    ];
  }

  if ($level === 'advance') {
    $allowed_html['ul'] = [
      'class' => [],
      'id'    => [],
    ];
    $allowed_html['ol'] = [
      'class' => [],
      'id'    => [],
    ];
    $allowed_html['li'] = [
      'class' => [],
      'id'    => [],
    ];
    $allowed_html['a'] = [
      'href'   => [],
      'title'  => [],
      'class'  => [],
      'id'     => [],
      'target' => [],
    ];
  }

  return $allowed_html;
}

/** ---------------------------------------------------------------
 * TJ Upload SVG file
 *---------------------------------------------------------------*/
function tj_el_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  $mimes['svgz'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'tj_el_mime_types', 10, 1);

/** ---------------------------------------------------------------
 * TJ Upload SVG for Elementor
 *---------------------------------------------------------------*/
function tj_el_unfiltered_files_upload() {
  //if exists, assign to $svg_support var
  $svg_support = get_option('elementor_unfiltered_files_upload');

  if (!$svg_support) {
    $svg_support = '1';
    update_option('elementor_unfiltered_files_upload', $svg_support);
  }
}
add_action('elementor/init', 'tj_el_unfiltered_files_upload');

/** ---------------------------------------------------------------
 * TJ Elementor support function
 *---------------------------------------------------------------*/
function tj_el_elementor_option_updated() {

  // Disable Elementor color schemes
  if (get_option('elementor_disable_color_schemes') !== 'yes') {
    update_option('elementor_disable_color_schemes', 'yes');
  }

  // Disable Elementor typography schemes
  if (get_option('elementor_disable_typography_schemes') !== 'yes') {
    update_option('elementor_disable_typography_schemes', 'yes');
  }

  // Set Elementor SVG Icons Experiment to Inactive
  if (get_option('elementor_experiment-e_font_icon_svg') !== 'inactive') {
    update_option('elementor_experiment-e_font_icon_svg', 'inactive');
  }

  // Support Elementor Custom Post Type
  $default_cpts = ['post', 'page', 'projects', 'services'];
  $ts_el_cpt = get_option('elementor_cpt_support', []);
  $ts_el_cpt = array_unique(array_merge($ts_el_cpt, $default_cpts));
  update_option('elementor_cpt_support', $ts_el_cpt);
}
register_activation_hook(__FILE__, 'tj_el_elementor_option_updated');
