<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Repeater;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Testimonials.
 */
class TJ_Testimonial extends Widget_Base {

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name() {
    return 'tj-testimonial';
  }

  // widget title.
  public function get_title() {
    return __('TJ Testimonial', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-testimonial tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'testimonial',
      'testimonials',
      'tj testimonial',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Testimonial Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
          7 => esc_html__('Style 07', 'tjcore'),
          8 => esc_html__('Style 08', 'tjcore'),
          9 => esc_html__('Style 09', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // _tj_section_content
    $this->start_controls_section(
      '_tj_review_content',
      [
        'label' => esc_html__('Review Content', 'tjcore'),
      ]
    );

    $repeater = new Repeater();
    $repeater->add_control(
      'field_condition',
      [
        'label' => __('Field condition', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          1 => __('Style 01', 'tjcore'),
          2 => __('Style 02', 'tjcore'),
        ],
        'default' => '1',
        'frontend_available' => true,
        'style_transfer' => true,
      ]
    );
    $repeater->add_control(
      'tj_testi_image',
      [
        'label'   => esc_html__('Reviewer Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],

      ]
    );
    $repeater->add_control(
      'tj_testi_rating',
      [
        'label'      => esc_html__('Rating', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['%'],
        'range'      => [
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => 80,
        ],
        'condition' => [
          'field_condition!' => ['1'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_testi_name',
      [
        'label'       => esc_html__('Name', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Florence R. Ochoa', 'tjcore'),
        'label_block' => true,
      ]
    );
    $repeater->add_control(
      'tj_testi_designation',
      [
        'label'       => esc_html__('Designation', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Sr. Executive', 'tjcore'),
        'label_block' => true,
      ]
    );
    $repeater->add_control(
      'tj_testi_text',
      [
        'label'   => esc_html__('Review Text', 'tjcore'),
        'type'    => Controls_Manager::TEXTAREA,
        'default' => esc_html__('scelerisque netus auctor suscipit vehicula one pellentesque elementum vehicula adipiscing natoque tortor fermentum fermentum to pellentesque per interdum este mauris.', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_testi_list',
      [
        'label'       => esc_html__('Review - List', 'tjcore'),
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater->get_controls(),
        'default'     => [
          [
            'tj_testi_name'        => esc_html__('Guy Hawkins', 'tjcore'),
            'tj_testi_designation' => esc_html__('Co. Founder', 'tjcore'),
            'tj_testi_text' => esc_html__('Working with Bexon has been a game-changer for our business. Their team’s professionalism, attention to detail, and innovative solutions have helped us streamline operations and achieve our goals faster than we imagined. We truly feel like a valued partner.', 'tjcore'),
          ],
          [
            'tj_testi_name'        => esc_html__('Ralph Edwards', 'tjcore'),
            'tj_testi_designation' => esc_html__('Co. Founder', 'tjcore'),
            'tj_testi_text' => esc_html__('The results we’ve seen after partnering with Bexon are beyond our expectations. They not only understood our vision but also brought new ideas to the table that have taken our business to the next level. Their expertise and commitment to success make them a trusted.', 'tjcore'),
          ],
          [
            'tj_testi_name'        => esc_html__('Devon Lane', 'tjcore'),
            'tj_testi_designation' => esc_html__('Co. Founder', 'tjcore'),
            'tj_testi_text' => esc_html__('We’ve been working with Bexonfor years, and they continue to deliver outstanding results. Their team is proactive, responsive, and always goes the extra mile to ensure our needs are met. They’ve become a key contributor to our growth and success that really help us', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ tj_testi_name }}}',
      ]
    );

    $this->add_control(
      'tj_quote_icon',
      [
        'label' => esc_html__('Quote Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-quote',
          'library' => 'tji',
        ],
        'fa4compatibility' => 'quote_icon',
        'condition' => [
          'tj_design_style!' => ['5', '6', '7'],
        ],
      ]
    );

    $this->add_control(
      'tj_heading',
      [
        'label'       => esc_html__('Heading', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => tj_kses('Client Feedback (4.8<span>/out of 200</span>)', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'tj_design_style' => ['4'],
        ],
      ]
    );
    $this->add_control(
      'tj_shape_image',
      [
        'label'   => esc_html__('Shape One', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style' => ['3', '7'],
        ],
      ]
    );
    $this->add_control(
      'tj_shape2_image',
      [
        'label'   => esc_html__('Shape Two', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style' => ['3'],
        ],
      ]
    );

    // animation
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInLeftBig'  => esc_html__('Fade In Left Big', 'tjcore'),
          'fadeInRightBig'  => esc_html__('Fade In Right Big', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    // slider settings
    $this->start_controls_section(
      '__tj_slider_settings',
      [
        'label' => esc_html__('Slider Settings', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'slide_loop',
      [
        'label'        => esc_html__('Is Loop?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider item loop?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_dot',
      [
        'label'        => esc_html__('Is Dots?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to show slider dots?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'condition' => [
          'tj_design_style!' => ['6']
        ]
      ]
    );
    $this->add_control(
      'slide_nav',
      [
        'label'        => esc_html__('Is Nav?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to show slider navigation?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'condition' => [
          'tj_design_style!' => ['6', '8']
        ]
      ]
    );
    $this->add_control(
      'slide_autoplay',
      [
        'label'        => esc_html__('Is Autoplay?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider auto play?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay_Delay',
      [
        'label'       => esc_html__('Autoplay Delay', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'description' => esc_html__('Set slider autoplay delay.', 'tjcore'),
        'min'         => 1000,
        'max'         => 10000,
        'step'        => 100,
        'default'     => 5000,
        'condition'   => [
          'slide_autoplay' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // card style
    $this->tj_section_style_controls('testimonial_wrapper', 'Wrapper- Style', '.tj-el-wrapper', ['1', '2', '3', '5', '6', '7', '8', '9']);
    $this->tj_card_style_controls('testimonial_card', 'Card- Style', '.tj-el-card');

    // title style
    $this->tj_basic_style_controls('testimonial_heading', 'Heading - Style', '.tj-el-heading', ['1', '2', '3', '5', '6', '7', '8', '9']);
    $this->tj_basic_style_controls('testimonial_title', 'Name - Style', '.tj-el-title');

    // designation style
    $this->tj_basic_style_controls('testimonial_desig', 'Designation - Style', '.tj-el-desig');

    // description style
    $this->tj_basic_style_controls('testimonial_desc', 'Description - Style', '.tj-el-desc');

    // image style
    $this->tj_img_style_controls('testimonial_image', 'Image - Style', '.tj-el-image');

    // Rating
    $this->start_controls_section(
      'section_rating_style',
      [
        'label' => esc_html__('Rating Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1', '2', '3', '4']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'rating_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .star-ratings > *, {{WRAPPER}} .star-ratings',
      ]
    );
    $this->add_control(
      'ricon_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .star-ratings .fill-ratings' => 'color: {{VALUE}}',
          '{{WRAPPER}} .star-ratings ' => '-webkit-text-stroke-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

    // icon style
    $this->tj_icon_style_controls('testimonial_icon', 'Quote Icon - Style', '.tj-el-icon', ['5', '6', '7', '8', '9']);

    // dots style
    $this->tj_swiper_dot_style_controls('swiper_dots', 'Dots - Style', '.swiper-pagination-area', ['4', '6']);
    $this->tj_swiper_nav_style_controls('swiper_navs', 'Nav - Style', '.testimonial-navigation', ['1', '2', '5', '6', '8', '9']);
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/testimonial/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Testimonial());
