<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Teams.
 */
class TJ_Team_Carousel extends Widget_Base {

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name() {
    return 'tj-team-carousel';
  }

  // widget title.
  public function get_title() {
    return __('TJ Team Carousel', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-person tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'teams',
      'carousel',
      'ts team',
      'ts',
      'ts addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {

    // Team Members
    $this->start_controls_section(
      'tj_team_members',
      [
        'label' => esc_html__('Members', 'tjcore'),
      ]
    );
    // repeater 
    $repeater = new Repeater();
    $repeater->add_control(
      'tj_member_image',
      [
        'type' => Controls_Manager::MEDIA,
        'label' => esc_html__('Image', 'tjcore'),
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $repeater->add_control(
      'tj_member_name',
      [
        'type' => Controls_Manager::TEXT,
        'label' => esc_html__('Name', 'tjcore'),
        'label_block' => true,
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $repeater->add_control(
      'tj_member_designation',
      [
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'label' => esc_html__('Designation', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $repeater->add_control(
      'member_url',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ],
        'dynamic'     => [
          'active' => true,
        ],
        'label_block' => true,
      ]
    );
    // REPEATER
    $this->add_control(
      'team_member_list',
      [
        'show_label' => false,
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tj_member_name' => esc_html__('Mike Hardson', 'tjcore'),
            'tj_member_designation' => esc_html__('Manager', 'tjcore'),
          ],
          [
            'tj_member_name' => esc_html__('David Cooper', 'tjcore'),
            'tj_member_designation' => esc_html__('Co Founder', 'tjcore'),
          ],
          [
            'tj_member_name' => esc_html__('Lucas Damian', 'tjcore'),
            'tj_member_designation' => esc_html__('Architect', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ tj_member_name }}}',
      ]
    );

    $this->add_control(
      'marquee_slide',
      [
        'label' => esc_html__('Slide Direction', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => 'right-to-left',
        'options' => [
          'left-to-right' => esc_html__('Left to Right', 'tjcore'),
          'right-to-left'  => esc_html__('Right to Left', 'tjcore'),
        ],
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();


    // carousel tab
    $this->start_controls_section(
      '__tj_carousel_settings',
      [
        'label' => esc_html__('Carousel Settings', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'slide_loop',
      [
        'label'             => esc_html__('Is Loop?', 'tjcore'),
        'type'              => Controls_Manager::SWITCHER,
        'label_on'          => esc_html__('Yes', 'tjcore'),
        'label_off'         => esc_html__('No', 'tjcore'),
        'description'       => esc_html__('Do you want to make this slider item loop?', 'tjcore'),
        'return_value'      => 'yes',
        'default'           => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay',
      [
        'label'             => esc_html__('Is Autoplay?', 'tjcore'),
        'type'              => Controls_Manager::SWITCHER,
        'label_on'          => esc_html__('Yes', 'tjcore'),
        'label_off'         => esc_html__('No', 'tjcore'),
        'description'       => esc_html__('Do you want to make this slider auto play?', 'tjcore'),
        'return_value'      => 'yes',
        'default'           => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay_delay',
      [
        'label' => esc_html__('Autoplay Delay', 'tjcore'),
        'type' => Controls_Manager::NUMBER,
        'description'       => esc_html__('Set slider autoplay delay.', 'tjcore'),
        'min' => 1,
        'max' => 10000,
        'step' => 100,
        'default' => 1,
        'condition' => [
          'slide_autoplay' => 'yes',
        ]
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // card style
    $this->tj_card_style_controls('team_card', 'Card - Style', '.tj-el-team');

    // title style
    $this->tj_basic_style_controls('team_title', 'Name - Style', '.tj-el-team .title');

    // designation style
    $this->tj_basic_style_controls('team_desig', 'Designation - Style', '.tj-el-team .designation');

    // image style
    $this->tj_img_style_controls('team_image', 'Image - Style', '.tj-el-team .team-img');
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/team-carousel/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Team_Carousel());
