<?php

namespace TJCore;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;



if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Tj Pricing Button.
 */
class TJ_Swiper_Navigation extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-swiper-navigation';
  }

  // widget title
  public function get_title()
  {
    return esc_html__('TJ Swiper Navigation Button', 'tjcore');
  }

  // widget icon
  public function get_icon()
  {
    return 'eicon-dual-button tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'testimonial',
      'testimonial navigation',
      'tj testimonial navigation button',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    $this->start_controls_section(
      'section_tab',
      [
        'label'         => esc_html__('Content', 'tjcore'),
      ]
    );

    $this->add_control(
      'tj_prev_icon',
      [
        'label'         => esc_html__('Prev Icon', 'tjcore'),
        'type'          => Controls_Manager::ICONS,
        'fa4compatibility' => 'icon',
        'default'          => [
          'value' => 'tji-arrow-left',
          'library' => 'tj',
        ],
      ]
    );

    $this->add_control(
      'tj_next_icon',
      [
        'label'         => esc_html__('Next Icon', 'tjcore'),
        'type'          => Controls_Manager::ICONS,
        'fa4compatibility' => 'icon',
        'default'          => [
          'value' => 'tji-arrow-right',
          'library' => 'tj',
        ],
      ]
    );


    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();


    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->start_controls_section(
      'section_nav_style',
      [
        'label' => esc_html__('Navigation', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->start_controls_tabs('navs_tabs');
    $this->start_controls_tab(
      'nav_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .navigation i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-next' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .slider-prev' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-next' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .slider-prev' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'nav_style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'icon_hover_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .navigation:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_bg_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-next:hover' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .slider-prev:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_border_hcolor',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-next:hover' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .slider-prev:hover' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();
  }

  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tjAnimation   = $settings['tj_animation'] ?? '';
    $tjAnimationName   = $settings['tj_animation_name'] ?? '';
    $tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

    $class = "slider-navigation d-md-inline-flex";
    if (!empty($tjAnimation)) {
      $class .= " wow $tjAnimationName";
      $this->add_render_attribute('tj-navigation-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
    }
    $this->add_render_attribute('tj-navigation-arg', 'class', $class);
?>

    <div <?php echo $this->get_render_attribute_string('tj-navigation-arg'); ?>>
      <div class="slider-prev navigation">
        <span class="anim-icon">
          <?php \Elementor\Icons_Manager::render_icon($settings['tj_prev_icon'], ['aria-hidden' => 'true']); ?>
          <?php \Elementor\Icons_Manager::render_icon($settings['tj_prev_icon'], ['aria-hidden' => 'true']); ?>
        </span>
      </div>
      <div class="slider-next navigation">
        <span class="anim-icon">
          <?php \Elementor\Icons_Manager::render_icon($settings['tj_next_icon'], ['aria-hidden' => 'true']); ?>
          <?php \Elementor\Icons_Manager::render_icon($settings['tj_next_icon'], ['aria-hidden' => 'true']); ?>
        </span>
      </div>
    </div>

<?php
  }
  protected function content_template() {}
}
$widgets_manager->register(new TJ_Swiper_Navigation());
