<?php

namespace TJCore;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Utils;


if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Sidebar CTA.
 */
class TJ_Sidebar_Cta extends Widget_Base {

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name() {
    return 'tj-sidebar-cta';
  }

  // widget title.
  public function get_title() {
    return __('TJ Sidebar CTA', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'tj-icon eicon-ehp-cta';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'sidebar-cta',
      'cta',
      'ts sidebar cta',
      'ts',
      'ts addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {

    // Sidebar group
    $this->start_controls_section(
      '_tj_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_image',
      [
        'label'   => esc_html__('Choose Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );

    $this->add_control(
      'cta_title',
      [
        'label'      => esc_html__('Title', 'tjcore'),
        'type'       => Controls_Manager::TEXTAREA,
        'default'    => esc_html__('Modern', 'tjcore'),
        'rows'       => 3,
      ]
    );

    $this->add_control(
      'cta_desc',
      [
        'label'      => esc_html__('Shor Description', 'tjcore'),
        'type'       => Controls_Manager::TEXTAREA,
        'default'    => esc_html__('Home Makeover', 'tjcore'),
        'rows'       => 3,
      ]
    );

    $this->add_control(
      'tj_button_show',
      [
        'label'        => esc_html__('Show Phone?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_btn_text',
      [
        'label'     => esc_html__('Phone Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('+8 (321) 890-640', 'tjcore'),
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'btn_icon',
        'default'          => [
          'value'   => 'tji-phone-3',
          'library' => 'tj',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
        'condition'        => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
        'separator' => 'before',
        'condition' => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_button_show'               => 'yes',
          'tj_btn_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_button_show' => 'yes',
          'tj_btn_link_type' => '2',
        ],
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();


    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // Wrapper style
    $this->tj_section_style_controls('box_wrapper', 'Wrapper - Style', '.widget-feature-item');

    $this->start_controls_section(
      'section_style_box',
      [
        'label' => esc_html__('Box', 'tjcore'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'box_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .feature-box',
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'box_border',
        'selector' => '{{WRAPPER}} .feature-box',
      ]
    );

    $this->add_control(
      'box_border_radius',
      [
        'label' => esc_html__('Border Radius', 'tjcore'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
          '{{WRAPPER}} .feature-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'box_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .feature-box .feature-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();

    // Title
    $this->start_controls_section(
      'section_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'title_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .feature-box .title' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'title_typography',
        'selector' => '{{WRAPPER}} .feature-box .title',
      ]
    );

    $this->end_controls_section();

    // Subtitle
    $this->start_controls_section(
      'section_style_subtitle',
      [
        'label' => esc_html__('Subtitle', 'tjcore'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'subtitle_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .feature-box .feature-content span' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'subtitle_typography',
        'selector' => '{{WRAPPER}} .feature-box .feature-content span',
      ]
    );

    $this->end_controls_section();

    // Contact Link
    $this->start_controls_section(
      'section_style_contact',
      [
        'label' => esc_html__('Contact Link', 'tjcore'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'contact_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .feature-box .feature-contact i' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'contact_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .feature-box .feature-contact span' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'contact_text_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .feature-box .feature-contact' => 'background: {{VALUE}}',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'contact_typography',
        'selector' => '{{WRAPPER}} .feature-box .feature-contact span',
      ]
    );

    $this->end_controls_section();

    // Image
    $this->start_controls_section(
      'section_style_image',
      [
        'label' => esc_html__('Image', 'tjcore'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_responsive_control(
      'image_max_width',
      [
        'label' => esc_html__('Width', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'selectors' => [
          '{{WRAPPER}} .feature-box .feature-images' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'image_max_height',
      [
        'label' => esc_html__('Height', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'selectors' => [
          '{{WRAPPER}} .feature-box .feature-images' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'border_image',
        'selector' => '{{WRAPPER}} .feature-box .feature-images',
      ]
    );

    $this->add_control(
      'image_border_radius',
      [
        'label' => esc_html__('Border Radius', 'tjcore'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
          '{{WRAPPER}} .feature-box .feature-images' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   *
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $ctaTitle = !empty($settings['cta_title']) ? $settings["cta_title"] : "";
    $cta_desc = !empty($settings['cta_desc']) ? $settings["cta_desc"] : "";

    // Button
    $tjButtonShow = !empty($settings['tj_button_show']) ? "yes" : 'no';
    $tjBtnText = $settings['tj_btn_text'] ?? '';
    $tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
    $tjBtnLink = $settings['tj_btn_link'] ?? '';
    $tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';

    if ('2' == $tjBtnLinkType) {
      $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
      $this->add_render_attribute('tj_button_arg', 'target', '_self');
      $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
      $this->add_render_attribute('tj_button_arg', 'class', "read-more feature-contact");
    } else {
      if (!empty($tjBtnLink['url'])) {
        $this->add_link_attributes('tj_button_arg', $tjBtnLink);
        $this->add_render_attribute('tj_button_arg', 'class', "read-more feature-contact");
      }
    }

    $tsAnimation   = $settings['tj_animation'] ?? '';
    $tsAnimationName   = $settings['tj_animation_name'] ?? '';
    $tsAnimationDelay   = $settings['tj_animation_delay'] ?? '';

    if (!empty($tsAnimation)) {
      $widgetClass = "tj-sidebar-widget widget-feature-item mb-0 wow $tsAnimationName";
      $this->add_render_attribute('tj-widget-arg', 'data-wow-delay', $tsAnimationDelay['size'] . "s");
    } else {
      $widgetClass = "tj-sidebar-widget widget-feature-item mb-0";
    }
    $this->add_render_attribute('tj-widget-arg', 'class', $widgetClass);

?>

    <div <?php echo $this->get_render_attribute_string('tj-widget-arg'); ?>>
      <div class="feature-box">
        <div class="feature-content">
          <?php if (!empty($ctaTitle)) : ?>
            <h2 class="title"><?php echo tj_kses($ctaTitle); ?></h2>
          <?php endif; ?>
          <?php if (!empty($cta_desc)) : ?>
            <span>
              <?php echo tj_kses($cta_desc); ?>
            </span>
          <?php endif; ?>
          <?php if ($tjButtonShow === 'yes'): ?>
            <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
              <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
              <span><?php echo esc_html__($tjBtnText, 'tjcore'); ?></span>
            </a>
          <?php endif; ?>
        </div>
        <?php if (!empty($settings['tj_image']['url'])): ?>
          <div class="feature-images">
            <img src="<?php echo esc_url($settings['tj_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image']['id'], '_wp_attachment_image_alt', true)); ?>">
          </div>
        <?php endif; ?>
      </div>
    </div>

<?php
  }
}
$widgets_manager->register(new TJ_Sidebar_Cta());
