<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Image.
 */
class TJ_Shape_Image extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-shape-image';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Shape Image', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-image tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'shape image',
      'media',
      'tj shape image',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    // _tj_image_content
    $this->start_controls_section(
      '_tj_image_content',
      [
        'label' => esc_html__('Image', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_image',
      [
        'label'   => esc_html__('Choose Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Image_Size::get_type(),
      [
        'name' => 'image_size',
        'exclude' => ['1536x1536', '2048x2048'],
        'include' => [],
        'default' => 'full',
      ]
    );

    $this->add_control(
      'tj_title',
      [
        'label'     => esc_html__('Title', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('Eade Marren', 'tjcore'),
        'label_block' => true
      ]
    );

    $this->add_control(
      'tj_content',
      [
        'label'     => esc_html__('Content', 'tjcore'),
        'type'      => Controls_Manager::TEXTAREA,
        'default'      => tj_kses("CEO & Founder"),
        'row' => 3,
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUpBig' => esc_html__('Fade In Upbig', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_image',
      [
        'label' => esc_html__('Image', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_responsive_control(
      'tj_image_width',
      [
        'label'      => esc_html__('Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .tj-image img' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_image_max_width',
      [
        'label'      => esc_html__('Max Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .tj-image img' => 'max-width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_image_height',
      [
        'label'      => esc_html__('Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .tj-image img' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'object-fit',
      [
        'label' => esc_html__('Object Fit', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'condition' => [
          'tj_image_height[size]!' => '',
        ],
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'fill' => esc_html__('Fill', 'tjcore'),
          'cover' => esc_html__('Cover', 'tjcore'),
          'contain' => esc_html__('Contain', 'tjcore'),
          'scale-down' => esc_html__('Scale Down', 'tjcore'),
        ],
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .tj-image img' => 'object-fit: {{VALUE}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'object-position',
      [
        'label' => esc_html__('Object Position', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          'center center' => esc_html__('Center Center', 'tjcore'),
          'center left' => esc_html__('Center Left', 'tjcore'),
          'center right' => esc_html__('Center Right', 'tjcore'),
          'top center' => esc_html__('Top Center', 'tjcore'),
          'top left' => esc_html__('Top Left', 'tjcore'),
          'top right' => esc_html__('Top Right', 'tjcore'),
          'bottom center' => esc_html__('Bottom Center', 'tjcore'),
          'bottom left' => esc_html__('Bottom Left', 'tjcore'),
          'bottom right' => esc_html__('Bottom Right', 'tjcore'),
        ],
        'default' => 'center center',
        'selectors' => [
          '{{WRAPPER}} .tj-image img' => 'object-position: {{VALUE}};',
        ],
        'condition' => [
          'tj_image_height[size]!' => '',
          'object-fit' => ['cover', 'contain', 'scale-down'],
        ],
      ]
    );

    $this->add_control(
      'overlay_blend_mode',
      [
        'label' => esc_html__('Blend Mode', 'elementor'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          '' => esc_html__('Normal', 'elementor'),
          'multiply' => esc_html__('Multiply', 'elementor'),
          'screen' => esc_html__('Screen', 'elementor'),
          'overlay' => esc_html__('Overlay', 'elementor'),
          'darken' => esc_html__('Darken', 'elementor'),
          'lighten' => esc_html__('Lighten', 'elementor'),
          'color-dodge' => esc_html__('Color Dodge', 'elementor'),
          'saturation' => esc_html__('Saturation', 'elementor'),
          'color' => esc_html__('Color', 'elementor'),
          'luminosity' => esc_html__('Luminosity', 'elementor'),
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-image' => 'mix-blend-mode: {{VALUE}}',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'tj_image_border',
        'selector' => '{{WRAPPER}} .tj-image',
      ]
    );

    $this->add_responsive_control(
      'tj_image_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    $this->tj_card_style_controls('image_card', 'Card- Style', '.tj-el-box');
    // title style
    $this->tj_basic_style_controls('title', 'Title - Style', '.tj-el-title');

    // description style
    $this->tj_basic_style_controls('desc', 'Description - Style', '.tj-el-desc');
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_design_style   = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/shape-image/style-' . $tj_design_style . '.php';
  }
}
$widgets_manager->register(new TJ_Shape_Image());
