<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Services Carousel.
 */
class TJ_Service_List extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-service-list';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Service List', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-post-list tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'service',
      'services',
      'tj service',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {


    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Service Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
          7 => esc_html__('Style 07', 'tjcore'),
        ],
        'default' => 1,
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
      'tj_service_tab_list',
      [
        'label' => esc_html__('Content List', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new Repeater();

    $repeater->add_control(
      'field_condition',
      [
        'label' => __('Field condition', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          1 => __('Style 01', 'tjcore'),
          2 => __('Style 02', 'tjcore'),
          3 => __('Style 03', 'tjcore'),
          4 => __('Style 04', 'tjcore'),
          5 => __('Style 05', 'tjcore'),
          6 => __('Style 06', 'tjcore'),
          7 => __('Style 07', 'tjcore'),
        ],
        'default' => '1',
        'frontend_available' => true,
        'style_transfer' => true,
      ]
    );
    $repeater->add_control(
      'tj_service_icon',
      [
        'label' => __('Icon', 'tjcore'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'label_block' => true,
        'fa4compatibility' => 'service_icon',
        'default' => [
          'value' => 'tji-service-1',
          'library' => 'tj',
        ]
      ]
    );
    $repeater->add_control(
      'tj_service_image',
      [
        'label' => esc_html__('Image', 'tjcore'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
        'condition'   => [
          'field_condition!' => ['1', '2', '5', '6'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_service_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('Business Strategy Development', 'tjcore'),
        'rows' => 3,
      ]
    );

    $repeater->add_control(
      'tj_service_desc',
      [
        'label'       => esc_html__('Description', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('Through a combination of data-driven insights and innovative approaches, we work closely with you to develop customized.', 'tjcore'),
        'rows' => 8,
        'condition'   => [
          'field_condition!' => ['5'],
        ],
      ]
    );

    $repeater->add_control(
      'tj_service_btn',
      [
        'label'       => esc_html__('Button', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Learn more', 'tjcore'),
        'condition'   => [
          'field_condition!' => ['1', '3', '5', '6', '7'],
        ],
      ]
    );

    $repeater->add_control(
      'tj_service_btn_icon',
      [
        'label' => __('Button Icon', 'tjcore'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'label_block' => false,
        'fa4compatibility' => 'btn_icon',
        'skin'             => 'inline',
        'default' => [
          'value' => 'tji-arrow-right-long',
          'library' => 'tj',
        ],
        'condition'   => [
          'field_condition!' => ['1', '3', '6'],
        ],
      ]
    );

    $repeater->add_control(
      'tj_service_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
      ]
    );
    $repeater->add_control(
      'tj_service_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_service_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $repeater->add_control(
      'tj_service_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_service_link_type' => '2',
        ],
      ]
    );

    // animation
    $repeater->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $repeater->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInLeftBig'  => esc_html__('Fade In Left Big', 'tjcore'),
          'fadeInRightBig'  => esc_html__('Fade In Right Big', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $repeater->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ]
      ]
    );

    $this->add_control(
      'tj_service_list',
      [
        'label' => '',
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tj_service_title' => tj_kses('Business Strategy Development'),
            'tj_service_desc' => tj_kses('Through a combination of data-driven insights and innovative approaches, we work closely with you to develop customized.'),
          ],
          [
            'tj_service_title' => tj_kses('Customer Experience Solutions'),
            'tj_service_desc' => tj_kses('Developing personalized customer journeys to increase satisfaction and loyalty of our expansion to keep competitive.'),
          ],
          [
            'tj_service_title' => tj_kses('Sustainability and ESG Consulting'),
            'tj_service_desc' => tj_kses('Provide tailored strategies that not only drive long-term value but also build trust with stakeholders, investors.'),
          ],
          [
            'tj_service_title' => tj_kses('Training and Development Programs'),
            'tj_service_desc' => tj_kses('Training and Development Programs are designed to empower employees with the skills, knowledge, and tools they need'),
          ],
        ],
        'title_field' => '{{{ tj_service_title }}}',
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // card style
    $this->tj_card_style_controls('service_card', 'Card- Style', '.tj-el-service');

    // icon style
    $this->tj_icon_style_controls_two('service_icon', 'Icon - Style', '.tj-el-service', '.tj-el-icon');

    // title style
    $this->tj_basic_style_controls_two('service_title', 'Title - Style', '.tj-el-service', '.tj-el-title',);

    // description style
    $this->tj_basic_style_controls_two('service_desc', 'Description - Style', '.tj-el-service', '.tj-el-desc', ['5']);

    // button style
    $this->tj_link_style_controls('button', 'Button - Style', '.tj-el-service', '.tj-el-btn .btn-text', ['1', '3', '5', '6', '7']);
    $this->tj_icon_style_controls_two('button_icon', 'Button Icon - Style', '.tj-el-service', '.tj-el-btn .btn-icon', ['1', '3', '6']);


    $this->start_controls_section(
      'scroll_progress_section',
      [
        'label' => esc_html__('Scroll Progress', 'tjcore'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        'condition'   => [
          'tj_design_style' => ['7'],
        ],
      ]
    );

    $this->add_control(
      'scroll_item_bg',
      [
        'label'     => esc_html__('Item Background', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-scroll-progress' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    // PADDING & RADIUS
    $this->add_responsive_control(
      'scroll_item_padding',
      [
        'label'      => esc_html__('Item Padding', 'tjcore'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-scroll-progress' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );

    /**
     * Number Style (.tj-scroll-progress-sln)
     */
    $this->add_control(
      'scroll_number_heading',
      [
        'label' => esc_html__('Step Number', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'scroll_number_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-scroll-progress-sln' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'scroll_number_typography',
        'selector' => '{{WRAPPER}} .tj-scroll-progress-sln',
      ]
    );

    /**
     * Progress Bar (.tj-scroll-progress-ind-inner)
     */
    $this->add_control(
      'scroll_bar_heading',
      [
        'label' => esc_html__('Progress Bar', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'scroll_bar_bg',
      [
        'label'     => esc_html__('Bar Background', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-scroll-progress-ind-inner' => 'background: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'scroll_bar_base_bg',
      [
        'label'     => esc_html__('Base Background', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-scroll-progress-ind' => 'background: {{VALUE}};',
        ],
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/service-list/style-' . $tj_design_style . '.php';
  }
}
$widgets_manager->register(new TJ_Service_List());
