<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for review.
 */
class TJ_Review extends Widget_Base {

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name() {
    return 'tj-review';
  }

  // widget title.
  public function get_title() {
    return __('TJ Review', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-review tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'review',
      'review-box',
      'tj reviw',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {

    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Review Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
        ],
        'default' => 1,
      ]
    );

    $this->end_controls_section();

    // _tj_review_content
    $this->start_controls_section(
      '_tj_review_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_quote_icon',
      [
        'label'         => esc_html__('Icon', 'tjcore'),
        'type'          => Controls_Manager::ICONS,
        'fa4compatibility' => 'tj_icon',
        'default'          => [
          'value' => 'tji-quote',
          'library' => 'tj',
        ],
        'condition' => [
          'tj_design_style!' => ['2', '3']
        ]
      ]
    );
    $this->add_control(
      'tj_review_desc',
      [
        'label' => esc_html__('Description', 'tjcore'),
        'type' => Controls_Manager::TEXTAREA,
        'rows' => 6,
        'default' => esc_html__('We believe in building lasting relationships with our clients through trust, innovation, and exceptional service.', 'tjcore'),
        'placeholder' => esc_html__('Type your description here', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ['2']
        ]
      ]
    );

    $this->add_control(
      'tj_rating_show',
      [
        'label' => esc_html__('Enable Rating?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
      ]
    );

    $this->add_control(
      'tj_rating_number',
      [
        'label'       => esc_html__('Number', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => esc_html__('4.9', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'tj_rating_show' => 'yes',
          'tj_design_style!' => ['1', '3']
        ]
      ]
    );

    $this->add_control(
      'tj_review_rating',
      [
        'label'      => esc_html__('Rating', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['%'],
        'range'      => [
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => 100,
        ],

        'condition' => [
          'tj_rating_show' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_review_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Name of reviewer', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_review_designation',
      [
        'label'       => esc_html__('Designation', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Co. Founder', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'tj_design_style!' => ['2']
        ]
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // card style
    $this->tj_card_style_controls('review_card', 'Card- Style', '.tj-el-box');

    // icon style
    $this->tj_icon_style_controls('quote_icon', 'Icon - Style', '.tj-el-icon', ['2', '3']);

    // title style
    $this->tj_basic_style_controls('review_title', 'Name - Style', '.tj-el-title');

    $this->tj_basic_style_controls('review_desig', 'Desination - Style', '.tj-el-desig', ['2']);

    // description style
    $this->tj_basic_style_controls('review_desc', 'Description / Number - Style', '.tj-el-desc');

    $this->start_controls_section(
      'section_style_rating_icon',
      [
        'label' => esc_html__('Rating Icon Style', 'tjcore'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'rating_icon_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::SLIDER,
        'range' => [
          'px' => [
            'min' => 10,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .star-ratings .fill-ratings' => 'font-size: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .star-ratings .empty-ratings' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'rating_icon_color',
      [
        'label' => esc_html__('Filled Icon Color', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .star-ratings .fill-ratings' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'rating_icon_empty_color',
      [
        'label' => esc_html__('Empty Icon Color', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .star-ratings .empty-ratings' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'rating_icon_stroke',
      [
        'label' => esc_html__('Stroke Color (Outline)', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .star-ratings' => '-webkit-text-stroke-color: {{VALUE}}; -webkit-text-stroke-width: 1px;',
        ],
        'separator' => 'before',
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/review/style-' . $tj_design_style . '.php';
  }
}
$widgets_manager->register(new TJ_Review());
