<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Repeater;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Pricing Accordion.
 */
class TJ_Pricing_Accordion extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-pricing-accordion';
  }

  // widget title.
  public function get_title() {
    return __('TJ Pricing Accordion', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-price-table tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'accordion',
      'pricing',
      'tj price',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    // Accordion items
    $this->start_controls_section(
      'tj_accordion_content',
      [
        'label' => esc_html__('Accordion Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'price_title',
      [
        'label'       => __('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'default'     => esc_html__('Basic Plan', 'tjcore'),
        'dynamic'     => [
          'active' => true,
        ],
      ]
    );
    $repeater->add_control(
      'price_description',
      [
        'label' => esc_html__('Description', 'tjcore'),
        'type' => Controls_Manager::TEXTAREA,
        'rows' => 3,
        'default' => esc_html__('Essential Business Services', 'tjcore'),
        'placeholder' => esc_html__('Type your description here', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'is_expand',
      [
        'label'             => esc_html__('Is Expand?', 'tjcore'),
        'type'              => Controls_Manager::SWITCHER,
        'label_on'          => esc_html__('Yes', 'tjcore'),
        'label_off'         => esc_html__('No', 'tjcore'),
        'description'       => esc_html__('Do you want to make this item expand?', 'tjcore'),
        'return_value'      => 'yes',
        'default'           => 'no',
      ]
    );
    $repeater->add_control(
      'more_options_1',
      [
        'label' => esc_html__('Pricing', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $repeater->add_control(
      'tj_price_currency',
      [
        'label'       => __('Currency', 'tjcore'),
        'type'        => Controls_Manager::SELECT,
        'label_block' => false,
        'options'     => [
          ''             => __('None', 'tjcore'),
          'baht'         => '&#3647; ' . _x('Baht', 'Currency Symbol', 'tjcore'),
          'bdt'          => '&#2547; ' . _x('BD Taka', 'Currency Symbol', 'tjcore'),
          'dollar'       => '&#36; ' . _x('Dollar', 'Currency Symbol', 'tjcore'),
          'euro'         => '&#128; ' . _x('Euro', 'Currency Symbol', 'tjcore'),
          'franc'        => '&#8355; ' . _x('Franc', 'Currency Symbol', 'tjcore'),
          'guilder'      => '&fnof; ' . _x('Guilder', 'Currency Symbol', 'tjcore'),
          'krona'        => 'kr ' . _x('Krona', 'Currency Symbol', 'tjcore'),
          'lira'         => '&#8356; ' . _x('Lira', 'Currency Symbol', 'tjcore'),
          'peseta'       => '&#8359 ' . _x('Peseta', 'Currency Symbol', 'tjcore'),
          'peso'         => '&#8369; ' . _x('Peso', 'Currency Symbol', 'tjcore'),
          'pound'        => '&#163; ' . _x('Pound Sterling', 'Currency Symbol', 'tjcore'),
          'real'         => 'R$ ' . _x('Real', 'Currency Symbol', 'tjcore'),
          'ruble'        => '&#8381; ' . _x('Ruble', 'Currency Symbol', 'tjcore'),
          'rupee'        => '&#8360; ' . _x('Rupee', 'Currency Symbol', 'tjcore'),
          'indian_rupee' => '&#8377; ' . _x('Rupee (Indian)', 'Currency Symbol', 'tjcore'),
          'shekel'       => '&#8362; ' . _x('Shekel', 'Currency Symbol', 'tjcore'),
          'won'          => '&#8361; ' . _x('Won', 'Currency Symbol', 'tjcore'),
          'yen'          => '&#165; ' . _x('Yen/Yuan', 'Currency Symbol', 'tjcore'),
          'custom'       => __('Custom', 'tjcore'),
        ],
        'default'     => 'dollar',
      ]
    );
    $repeater->add_control(
      'tj_currency_custom',
      [
        'label'     => __('Custom Symbol', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'condition' => [
          'price_currency' => 'custom',
        ],
        'dynamic'   => [
          'active' => true,
        ],
      ]
    );
    $repeater->add_control(
      'tj_price',
      [
        'label'   => __('Price', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('99', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $repeater->add_control(
      'tj_price_period',
      [
        'label'   => __('Period', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('/per month', 'tjcore'),
      ]
    );

    $repeater->add_control(
      'more_options_2',
      [
        'label' => esc_html__('Features', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $repeater->add_control(
      'tj_price_features',
      [
        'label' => esc_html__('Features', 'tjcore'),
        'type' => Controls_Manager::TEXTAREA,
        'rows' => 10,
        'placeholder' => esc_html__('Type your features here', 'tjcore'),
        'default' => tj_kses('<ul>
          <li><i class="tji-list"></i>Access to core services</li>
          <li><i class="tji-list"></i>Limited customer support (email)</li>
          <li><i class="tji-list"></i>1 project per month</li>
          <li><i class="tji-list"></i>Basic reporting and analytics</li>
          <li><i class="tji-list"></i>Standard templates and tools</li>
          <li><i class="tji-list"></i>Basic performance tracking</li>
        </ul>'),
      ]
    );

    $repeater->add_control(
      'more_options_3',
      [
        'label' => esc_html__('Button', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $repeater->add_control(
      'tj_btn_text',
      [
        'label'       => esc_html__('Button Text', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Choose Plan', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'tj_btn_link_type',
      [
        'label'       => esc_html__('Button Link Type', 'tjcore'),
        'type'        => Controls_Manager::SELECT,
        'options'     => [
          '1' => 'Custom Link',
          '2' => 'Internal Page',
        ],
        'default'     => '1',
      ]
    );
    $repeater->add_control(
      'tj_btn_link',
      [
        'label'         => esc_html__('Button link', 'tjcore'),
        'type'          => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'placeholder'   => esc_html__('https://your-link.com', 'tjcore'),
        'show_external' => false,
        'default'       => [
          'url'               => '#',
          'is_external'       => true,
          'nofollow'          => true,
          'custom_attributes' => '',
        ],
        'condition'     => [
          'tj_btn_link_type' => '1',
        ],
        'label_block'   => true,
      ]
    );
    $repeater->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page Link', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_btn_link_type' => '2',
        ],
      ]
    );
    $repeater->add_control(
      'tj_btn_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-arrow-right-long',
          'library' => 'tj',
        ],
        'fa4compatibility' => 'btn_icon',
        'skin' => 'inline',
        'label_block' => false
      ]
    );

    // animation
    $repeater->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $repeater->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => 'fadeInUp',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $repeater->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ]
      ]
    );
    $this->add_control(
      'tj_accordion_list',
      [
        'label'       => esc_html__('Accordion - List', 'tjcore'),
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater->get_controls(),
        'default'     => [
          [
            'price_title' => esc_html__('Basic Plan', 'tjcore'),
          ],
          [
            'price_title' => esc_html__('Standard Plan', 'tjcore'),
          ],
          [
            'price_title' => esc_html__('Premium Plan', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ price_title }}}',
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->start_controls_section(
      'section_style_accordion_wrapper',
      [
        'label' => esc_html__('Accordion Item', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    // Start tabs for Normal and Active states
    $this->start_controls_tabs('tabs_accordion_wrapper_states');

    /** Normal State Tab */
    $this->start_controls_tab(
      'tab_accordion_wrapper_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'accordion_wrapper_background_normal',
        'label'    => esc_html__('Background', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item',
        'exclude'  => ['image', 'video'],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'accordion_wrapper_border_normal',
        'label'    => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item',
      ]
    );
    $this->end_controls_tab();

    /** Active State Tab */
    $this->start_controls_tab(
      'tab_accordion_wrapper_active',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'accordion_wrapper_background_active',
        'label'    => esc_html__('Background', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item.active',
        'exclude'  => ['image', 'video'],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'accordion_wrapper_border_active',
        'label'    => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item.active',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    // Border radius
    $this->add_responsive_control(
      'accordion_wrapper_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before',
      ]
    );
    // Padding
    $this->add_responsive_control(
      'accordion_wrapper_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    // Margin
    $this->add_responsive_control(
      'accordion_wrapper_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();


    $this->start_controls_section(
      'section_style_accordion_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    // Typography control for accordion title
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'accordion_title_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item .faq-title',
      ]
    );
    // Tabs for Normal and Active states styling
    $this->start_controls_tabs('tabs_accordion_title_states');
    // Normal state tab
    $this->start_controls_tab(
      'tab_accordion_title_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'accordion_title_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-item .faq-title' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->end_controls_tab();

    // Active state tab
    $this->start_controls_tab(
      'tab_accordion_title_active',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'accordion_title_color_active',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-item.active .faq-title' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->add_control(
      'accordion_title_border_color_active',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-item.active .faq-title' => 'border-bottom-color: {{VALUE}};',
          '{{WRAPPER}} .accordion.pricing-accordion .pricing-inner::after' => 'background-color: {{VALUE}};',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    // Responsive padding control
    $this->add_responsive_control(
      'accordion_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-item .faq-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    // Responsive margin control
    $this->add_responsive_control(
      'accordion_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-item .faq-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // icon
    $this->start_controls_section(
      'section_style_accordion_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    // Icon font size
    $this->add_control(
      'accordion_icon_font_size',
      [
        'label' => esc_html__('Icon Font Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem'],
        'range' => [
          'px' => ['min' => 0, 'max' => 100],
        ],
        'selectors' => [
          '{{WRAPPER}} .accordion-item .faq-title::after' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    // Start Normal / Active Tabs
    $this->start_controls_tabs('tabs_accordion_icon_states');
    /** Normal Tab */
    $this->start_controls_tab(
      'tab_accordion_icon_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'accordion_icon_color_normal',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-item .faq-title::after' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->add_control(
      'accordion_icon_bgcolor_normal',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-item .faq-title::after' => 'background-color: {{VALUE}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'accordion_icon_border_normal',
        'selector' => '{{WRAPPER}} .accordion-item .faq-title::after',
      ]
    );
    $this->end_controls_tab();

    /** Active Tab */
    $this->start_controls_tab(
      'tab_accordion_icon_active',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'accordion_icon_color_active',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-item.active .faq-title::after' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->add_control(
      'accordion_icon_bgcolor_active',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-item.active .faq-title::after' => 'background-color: {{VALUE}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'accordion_icon_border_active',
        'selector' => '{{WRAPPER}} .accordion-item.active .faq-title::after',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs(); // End of Tabs

    $this->add_responsive_control(
      'accordion_icon_width_normal',
      [
        'label' => esc_html__('Width', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .accordion-item .faq-title::after' => 'width: {{SIZE}}{{UNIT}};',
        ],
        'separator' => 'before',
      ]
    );
    $this->add_responsive_control(
      'accordion_icon_height_normal',
      [
        'label' => esc_html__('Height', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .accordion-item .faq-title::after' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'accordion_icon_border_radius',
      [
        'label' => esc_html__('Border Radius', 'tjcore'),
        'type'  => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
          '{{WRAPPER}} .accordion-item .faq-title::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section(); // End of Section

    // content
    $this->start_controls_section(
      'section_style_accordion_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    // Typography control for accordion title
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'accordion_content_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item .accordion-body p',
      ]
    );
    $this->add_control(
      'accordion_content_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-item .accordion-body p' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'accordion_content_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-item .accordion-body p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'accordion_content_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-item .accordion-body p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // price
    $this->start_controls_section(
      'section_style_accordion_price',
      [
        'label' => esc_html__('Price', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'price_currency_typography',
        'label'    => esc_html__('Currency Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .pricing-box .package-currency',
      ]
    );
    $this->add_control('price_currency_color', [
      'label' => esc_html__('Currency Color', 'tjcore'),
      'type'  => Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-box .package-currency' => 'color: {{VALUE}};',
      ],
      'separator' => 'after'
    ]);

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'price_number_typography',
        'label'    => esc_html__('Price Number Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .pricing-box .price-number',

      ]
    );
    $this->add_control('price_number_color', [
      'label' => esc_html__('Price Number Color', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-box .price-number' => 'color: {{VALUE}};',
      ],
      'separator' => 'after'
    ]);

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'price_period_typography',
        'label'    => esc_html__('Period Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .pricing-box .package-period',
      ]
    );
    $this->add_control('price_period_color', [
      'label' => esc_html__('Period Color', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-box .package-period' => 'color: {{VALUE}};',
      ],
    ]);
    $this->end_controls_section();

    // price button
    $this->start_controls_section('section_style_pricing_button', [
      'label' => esc_html__('Pricing Button', 'tjcore'),
      'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
    ]);

    // Typography
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'pricing_btn_typography',
        'selector' => '{{WRAPPER}} .pricing-btn .text-btn .btn-text',
      ]
    );
    $this->start_controls_tabs('tabs_pricing_button_style');
    $this->start_controls_tab('tab_pricing_button_normal', [
      'label' => esc_html__('Normal', 'tjcore'),
    ]);
    $this->add_control('pricing_btn_text_color', [
      'label' => esc_html__('Text Color', 'tjcore'),
      'type' => Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn .btn-text' => 'color: {{VALUE}};',
      ],
    ]);
    $this->add_control('pricing_btn_bg_color', [
      'label' => esc_html__('Background Color', 'tjcore'),
      'type' => Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn' => 'background-color: {{VALUE}};',
      ],
    ]);
    $this->add_control('pricing_btn_icon_color', [
      'label' => esc_html__('Icon Color', 'tjcore'),
      'type' => Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn .btn-icon i' => 'color: {{VALUE}};',
      ],
    ]);
    $this->add_control('pricing_btn_icon_bg_color', [
      'label' => esc_html__('Icon Background Color', 'tjcore'),
      'type' => Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn .btn-icon' => 'background-color: {{VALUE}};',
      ],
    ]);
    $this->end_controls_tab();

    // === Hover Tab ===
    $this->start_controls_tab('tab_pricing_button_hover', [
      'label' => esc_html__('Hover', 'tjcore'),
    ]);
    $this->add_control('pricing_btn_hover_text_color', [
      'label' => esc_html__('Text Color (Hover)', 'tjcore'),
      'type' => Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn:hover .btn-text' => 'color: {{VALUE}};',
        '{{WRAPPER}} .pricing-box.active .pricing-btn .text-btn .btn-text' => 'color: {{VALUE}};',
      ],
    ]);
    $this->add_control('pricing_btn_hover_bg_color', [
      'label' => esc_html__('Background Color (Hover)', 'tjcore'),
      'type' => Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn:hover' => 'background-color: {{VALUE}};',
        '{{WRAPPER}} .pricing-box.active .pricing-btn .text-btn' => 'background-color: {{VALUE}};',
      ],
    ]);
    $this->add_control('pricing_btn_icon_hover_color', [
      'label' => esc_html__('Icon Color (Hover)', 'tjcore'),
      'type' => Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn:hover .btn-icon i' => 'color: {{VALUE}};',
        '{{WRAPPER}} .pricing-box.active .pricing-btn .text-btn .btn-icon i' => 'color: {{VALUE}};',
      ],
    ]);
    $this->add_control('pricing_btn_border_hover_color', [
      'label' => esc_html__('Border Color', 'tjcore'),
      'type' => Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn:hover' => 'color: {{VALUE}};',
        '{{WRAPPER}} .pricing-box.active .pricing-btn .text-btn' => 'color: {{VALUE}};',
      ],
    ]);
    $this->end_controls_tab();
    $this->end_controls_tabs();

    // Border
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'pricing_btn_border',
        'selector' => '{{WRAPPER}} .pricing-btn .text-btn',
        'separator' => 'before'
      ]
    );
    // Border Radius
    $this->add_responsive_control('pricing_btn_radius', [
      'label' => esc_html__('Border Radius', 'tjcore'),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => ['px', '%', 'em'],
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
      ],
    ]);
    // Padding
    $this->add_responsive_control('pricing_btn_padding', [
      'label' => esc_html__('Padding', 'tjcore'),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => ['px', '%', 'em'],
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
      ],
    ]);
    $this->end_controls_section();

    // features
    $this->start_controls_section('section_style_feature_list', [
      'label' => esc_html__('Feature List', 'tjcore'),
      'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
    ]);
    // Typography
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'feature_list_typography',
        'selector' => '{{WRAPPER}} .list-items ul li',
      ]
    );

    $this->start_controls_tabs('tabs_feature_list_style');
    $this->start_controls_tab('tab_feature_list_normal', [
      'label' => esc_html__('Normal', 'tjcore'),
    ]);
    $this->add_control('feature_list_text_color', [
      'label' => esc_html__('Text Color', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .list-items ul li' => 'color: {{VALUE}};',
      ],
    ]);
    $this->add_control('feature_list_icon_color', [
      'label' => esc_html__('Icon Color', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .list-items ul li i' => 'color: {{VALUE}};',
      ],
    ]);
    $this->end_controls_tab();

    // === Active Tab ===
    $this->start_controls_tab('tab_feature_list_active', [
      'label' => esc_html__('Active', 'tjcore'),
    ]);
    $this->add_control('feature_list_text_active_color', [
      'label' => esc_html__('Text Color (Active)', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .list-items ul li.active' => 'color: {{VALUE}};',
      ],
    ]);
    $this->add_control('feature_list_icon_active_color', [
      'label' => esc_html__('Icon Color (Active)', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .list-items ul li.active i' => 'color: {{VALUE}};',
      ],
    ]);
    $this->end_controls_tab();
    $this->end_controls_tabs();

    // Icon Size
    $this->add_control('feature_list_icon_size', [
      'label' => esc_html__('Icon Size', 'tjcore'),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'range' => [
        'px' => ['min' => 10, 'max' => 50],
      ],
      'selectors' => [
        '{{WRAPPER}} .list-items ul li i' => 'font-size: {{SIZE}}{{UNIT}};',
      ],
      'separator' => 'before'
    ]);
    // Icon Spacing
    $this->add_control('feature_list_icon_spacing', [
      'label' => esc_html__('Icon Spacing', 'tjcore'),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'range' => [
        'px' => ['min' => 0, 'max' => 50],
      ],
      'selectors' => [
        '{{WRAPPER}} .list-items ul li i' => 'margin-right: {{SIZE}}{{UNIT}};',
      ],
    ]);
    // Item Gap
    $this->add_control('feature_list_item_gap', [
      'label' => esc_html__('Item Spacing', 'tjcore'),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'range' => [
        'px' => ['min' => 0, 'max' => 50],
      ],
      'selectors' => [
        '{{WRAPPER}} .list-items ul li' => 'margin-bottom: {{SIZE}}{{UNIT}};',
      ],
    ]);
    $this->end_controls_section();
  }

  private static function get_currency_symbol($symbol_name) {
    $symbols = [
      'baht'         => '&#3647;',
      'bdt'          => '&#2547;',
      'dollar'       => '&#36;',
      'euro'         => '&#128;',
      'franc'        => '&#8355;',
      'guilder'      => '&fnof;',
      'indian_rupee' => '&#8377;',
      'pound'        => '&#163;',
      'peso'         => '&#8369;',
      'peseta'       => '&#8359',
      'lira'         => '&#8356;',
      'ruble'        => '&#8381;',
      'shekel'       => '&#8362;',
      'rupee'        => '&#8360;',
      'real'         => 'R$',
      'krona'        => 'kr',
      'won'          => '&#8361;',
      'yen'          => '&#165;',
    ];

    return isset($symbols[$symbol_name]) ? $symbols[$symbol_name] : '';
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/pricing-accordion/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Pricing_Accordion());
