<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Stroke;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Marquee.
 */
class TJ_Marquee extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-marquee';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Marquee', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-divider-shape tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'marquee',
      'marquees',
      'tj marquee',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }


  /**
   * widget controls.
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Marquee Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // tj_marquee_tab
    $this->start_controls_section(
      'tj_marquee_tab',
      [
        'label' => esc_html__('Marquee', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'tj_marquee_image',
      [
        'label' => esc_html__('Image', 'tjcore'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $repeater->add_control(
      'tj_marquee_title',
      [
        'label'         => esc_html__('Title', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('List Content', 'tjcore'),
        'label_block'   => true,
      ]
    );
    $this->add_control(
      'tj_marquee_list',
      [
        'label'         => esc_html__('Marquees List', 'tjcore'),
        'type'          => Controls_Manager::REPEATER,
        'fields'        => $repeater->get_controls(),
        'default'       => [
          [
            'tj_marquee_title'       => esc_html__('Innovation', 'tjcore'),
          ],
          [
            'tj_marquee_title'       => esc_html__('Success', 'tjcore'),
          ],
          [
            'tj_marquee_title'       => esc_html__('Leadership', 'tjcore'),
          ],
          [
            'tj_marquee_title'       => esc_html__('Enterprise', 'tjcore'),
          ],
          [
            'tj_marquee_title'       => esc_html__('Corporate', 'tjcore'),
          ],
          [
            'tj_marquee_title'       => esc_html__('Consulting', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ tj_marquee_title }}}',
        'condition' => [
          'tj_design_style!' => ['3', '4']
        ]
      ]
    );

    $repeater2 = new Repeater();
    $repeater2->add_control(
      'tj_marquee_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'fa4compatibility' => 'marquee_icon',
        'default' => [
          'value' => 'tji-star',
          'library' => 'tji',
        ],
      ]
    );
    $repeater2->add_control(
      'tj_marquee_2_title',
      [
        'label'         => esc_html__('Title', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('List Content', 'tjcore'),
        'label_block'   => true,
      ]
    );
    $this->add_control(
      'tj_marquee_2_list',
      [
        'label'         => esc_html__('Marquees List', 'tjcore'),
        'type'          => Controls_Manager::REPEATER,
        'fields'        => $repeater2->get_controls(),
        'default'       => [
          [
            'tj_marquee_2_title'       => esc_html__('Innovation', 'tjcore'),
          ],
          [
            'tj_marquee_2_title'       => esc_html__('Success', 'tjcore'),
          ],
          [
            'tj_marquee_2_title'       => esc_html__('Leadership', 'tjcore'),
          ],
          [
            'tj_marquee_2_title'       => esc_html__('Enterprise', 'tjcore'),
          ],
          [
            'tj_marquee_2_title'       => esc_html__('Business Growth', 'tjcore'),
          ],
          [
            'tj_marquee_2_title'       => esc_html__('Corporate', 'tjcore'),
          ],
          [
            'tj_marquee_2_title'       => esc_html__('Results', 'tjcore'),
          ],
          [
            'tj_marquee_2_title'       => esc_html__('Innovation', 'tjcore'),
          ],
          [
            'tj_marquee_2_title'       => esc_html__('Success', 'tjcore'),
          ],
          [
            'tj_marquee_2_title'       => esc_html__('Leadership', 'tjcore'),
          ],
          [
            'tj_marquee_2_title'       => esc_html__('Enterprise', 'tjcore'),
          ],
          [
            'tj_marquee_2_title'       => esc_html__('Business Growth', 'tjcore'),
          ],
          [
            'tj_marquee_2_title'       => esc_html__('Corporate', 'tjcore'),
          ],
          [
            'tj_marquee_2_title'       => esc_html__('Results', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ tj_marquee_2_title }}}',
        'condition' => [
          'tj_design_style' => ['3', '4']
        ]
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->tj_section_style_controls('tj_marquee_section', 'Marquee Section - Style', '.h5-maquee-inner', ['1', '2']);

    $this->tj_img_style_controls('marquee_image', 'Image - Style', '.marquee-img', ['3']);

    $this->start_controls_section('section_style_marquee_icon', [
      'label' => esc_html__('Marquee Icon', 'tjcore'),
      'tab'   => Controls_Manager::TAB_STYLE,
      'condition' => [
        'tj_design_style' => ['3']
      ]
    ]);
    $this->add_control(
      'marquee_icon_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .marquee-box .marquee-icon' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'marquee_icon_color',
      [
        'label' => esc_html__('Icon Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .marquee-box .marquee-icon' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section('section_style_marquee_text', [
      'label' => esc_html__('Marquee Text', 'tjcore'),
      'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
    ]);
    // Typography
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'marquee_text_typography',
        'selector' => '{{WRAPPER}} .marquee-text, {{WRAPPER}} .marquee-title .title',
      ]
    );
    // Text Color
    $this->add_control('marquee_text_color', [
      'label' => esc_html__('Text Color', 'tjcore'),
      'type' => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .marquee-text' => '-webkit-text-fill-color: {{VALUE}};',
        '{{WRAPPER}} .marquee-title .title' => 'color: {{VALUE}};',
      ],
    ]);
    // Stroke Color
    $this->add_control('marquee_text_stroke_color', [
      'label' => esc_html__('Stroke Color', 'tjcore'),
      'type' => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .marquee-text' => '-webkit-text-stroke-color: {{VALUE}};',
      ],
      'condition' => [
        'tj_design_style!' => ['3']
      ]
    ]);
    // Stroke Width
    $this->add_control('marquee_text_stroke_width', [
      'label' => esc_html__('Stroke Width', 'tjcore'),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'range' => [
        'px' => ['min' => 0, 'max' => 10],
      ],
      'selectors' => [
        '{{WRAPPER}} .marquee-text' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',
      ],
      'condition' => [
        'marquee_text_stroke_color!' => '',
        'tj_design_style!' => ['3']
      ],
    ]);
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/marquee/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Marquee());
