<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Icon Box.
 */
class TJ_Info_Box extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-info-box';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Info Box', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-info-box tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'info',
      'info-box',
      'tj info-box',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Info box Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // _tj_icon_box_content
    $this->start_controls_section(
      '_tj_info_box_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Get Started Free Call?', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'tj_design_style!' => ['3']
        ]
      ]
    );
    $this->add_control(
      'tj_desc',
      [
        'label'       => esc_html__('Description', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('Recognized by industry leaders, of our award-winning team has a proven record of delivering excellence across projects', 'tjcore'),
        'row' => 3,
        'condition' => [
          'tj_design_style!' => ['1', '3']
        ]
      ]
    );
    $this->add_control(
      'tj_info_icon',
      [
        'label'         => esc_html__('Icon', 'tjcore'),
        'type'          => Controls_Manager::ICONS,
        'fa4compatibility' => 'tj_icon',
        'label_block' => true,
        'skin'             => 'inline',
        'default'          => [
          'value' => 'tji-phone',
          'library' => 'tj',
        ],
        'condition' => [
          'tj_design_style!' => ['2']
        ]
      ]
    );
    $this->add_control(
      'tj_info_title',
      [
        'label'       => esc_html__('Contact Info', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('1-888-452-1505', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'tj_design_style!' => ['2']
        ]
      ]
    );
    $this->add_control(
      'tj_info_link',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'default' => [
          'url' => '',
          'is_external' => false,
          'nofollow' => false,
        ],
        'condition' => [
          'tj_design_style!' => ['2']
        ]
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // wrapper style
    $this->tj_section_style_controls('info_card_wrap', 'Card Wrapper- Style', '.tj-el-boxwrap', ['2']);

    // card style
    $this->tj_card_style_controls('info_card', 'Card- Style', '.tj-el-box');

    // icon style
    $this->tj_icon_style_controls('info_icon', 'Icon - Style', '.tj-el-icon', ['2']);

    // title style
    $this->tj_basic_style_controls('info_title', 'Title - Style', '.tj-el-title');
    $this->tj_basic_style_controls('info_desc', 'Description - Style', '.tj-el-desc', ['1']);

    // phone style
    $this->tj_basic_style_controls('info_phone', 'Phone - Style', '.tj-el-phone', ['2']);
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/info-box/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Info_Box());
