<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Footer Subscription.
 */
class TJ_Footer_Subscription extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-footer-subscription';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Footer Subscription', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-form-vertical tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'subscription',
      'cta',
      'tj cta',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  // Get Contact Form
  public function get_tj_contact_form()
  {
    if (!class_exists('WPCF7')) {
      return;
    }
    $tj_cfa     = array();
    $tj_cf_args = array('posts_per_page' => -1, 'post_type' => 'wpcf7_contact_form');
    $tj_forms   = get_posts($tj_cf_args);
    $tj_cfa     = ['0' => esc_html__('Select Form', 'tjcore')];
    if ($tj_forms) {
      foreach ($tj_forms as $tj_form) {
        $tj_cfa[$tj_form->ID] = $tj_form->post_title;
      }
    } else {
      $tj_cfa[esc_html__('No contact form found', 'tjcore')] = 0;
    }
    return $tj_cfa;
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Subscribe Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();


    $this->start_controls_section(
      '_tj_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
      ]
    );

    $this->add_control(
      'tj_title',
      [
        'label'         => esc_html__('Widget Title', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('Subscribe to Our Newsletter.', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'tj_design_style!' => ['1'],
        ],
      ]
    );

    // form style
    $this->add_control(
      'form_style',
      [
        'label'   => esc_html__('Form', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'default' => 'shortcode',
        'options' => [
          'shortcode' => esc_html__('Shortcode', 'tjcore'),
          'cf7-form'  => esc_html__('Contact Form 7', 'tjcore'),
        ],
      ]
    );
    // cf7
    $this->add_control(
      'tj_select_form',
      [
        'label'     => esc_html__('Select Form', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'separator' => 'before',
        'options'   => $this->get_tj_contact_form(),
        'condition' => [
          'form_style' => 'cf7-form',
        ],
      ]
    );
    // shortcode
    $this->add_control(
      'tj_shortcode',
      [
        'label'       => esc_html__('Shortcode', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'condition'   => [
          'form_style' => 'shortcode',
        ],
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => 'fadeInUp',
        'options'   => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.2,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // wrapper style
    $this->tj_section_style_controls('from_wrap', 'Form Wrapper- Style', '.tj-el-form');

    // title style
    $this->tj_basic_style_controls('widget_title', 'Title - Style', '.tj-el-title', ['1']);

    // field style
    $this->tj_input_style_controls('from_fields', 'Form Fields - Style', '.subscribe-form');

    //button style
    $this->tj_button_style_controls_two('button', 'Button - Style', '.subscribe-form button', '.btn-text', ['2', '3']);
    $this->tj_icon_style_controls_two('button_icon', 'Button Icon - Style', '.subscribe-form button', '.btn-icon', ['2', '3']);

    // button icon style
    $this->tj_icon_style_controls('form_icon', 'Icon - Style', '.subscribe-form button', ['1', '4']);

    $this->start_controls_section(
      'section_style_checkbox',
      [
        'label' => esc_html__('Checkbox Agreement', 'tjcore'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'checkbox_label_color',
      [
        'label' => esc_html__('Label Text Color', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} label' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'checkbox_label_typography',
        'selector' => '{{WRAPPER}} label',
      ]
    );

    $this->add_responsive_control(
      'checkbox_label_spacing',
      [
        'label'      => esc_html__('Label Spacing', 'tjcore'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'selectors'  => [
          '{{WRAPPER}} label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    //
    // Checkbox Input Styling
    //
    $this->add_control(
      'checkbox_input_size',
      [
        'label' => esc_html__('Checkbox Size', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::SLIDER,
        'range' => [
          'px' => [
            'min' => 10,
            'max' => 50,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} input[type="checkbox"]' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'checkbox_input_border',
        'selector' => '{{WRAPPER}} input[type="checkbox"]',
      ]
    );

    $this->add_responsive_control(
      'checkbox_input_margin',
      [
        'label' => esc_html__('Checkbox Margin', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::DIMENSIONS,
        'selectors' => [
          '{{WRAPPER}} input[type="checkbox"]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    //
    // Link Styling
    //
    $this->add_control(
      'checkbox_link_heading',
      [
        'label' => esc_html__('Link Styling (Terms)', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->start_controls_tabs('tabs_checkbox_link');

    $this->start_controls_tab(
      'tab_checkbox_link_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );

    $this->add_control(
      'checkbox_link_color',
      [
        'label' => esc_html__('Link Color', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} label a' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_tab();

    $this->start_controls_tab(
      'tab_checkbox_link_hover',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );

    $this->add_control(
      'checkbox_link_hover_color',
      [
        'label' => esc_html__('Hover Color', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} label a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'checkbox_link_typography',
        'selector' => '{{WRAPPER}} label a',
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/footer-subscription/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Footer_Subscription());
