<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Socials.
 */
class TJ_Footer_Contact extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-footer-contact';
  }

  // widget title.
  public function get_title() {
    return __('TJ Footer Contact', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-tel-field tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'contacts',
      'contact',
      'tj contact',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }


  /**
   * widget controls.
   */
  protected function register_controls() {

    $this->start_controls_section(
      '_tj_contact_info',
      [
        'label' => esc_html__('Contact Content', 'tjcore'),
      ]
    );

    $this->add_control(
      'tj_title',
      [
        'label'         => esc_html__('Widget Title', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('Our offices', 'tjcore'),
        'label_block' => true,
      ]
    );

    $repeater = new Repeater();

    $repeater->add_control(
      'tj_info_content',
      [
        'label'         => esc_html__('Content', 'tjcore'),
        'type'          => Controls_Manager::TEXTAREA,
        'default'       => esc_html__('993 Renner Burg, West Rond, MT 94251-030', 'tjcore'),
        'row'           => '3',
        'label_block' => true,
      ]
    );

    $this->add_control(
      'tj_contact_list',
      [
        'label' => esc_html__('Contact Info List', 'tjcore'),
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tj_info_content' => esc_html__('993 Renner Burg, West Rond, MT 94251-030', 'tjcore'),
          ],
          [
            'tj_info_content' => esc_html__('Suite 452 8082 Boner Parge, Elviraton, CA 48998', 'tjcore'),
          ]
        ],
        'title_field' => '{{{ tj_info_content }}}',
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => 'fadeInUp',
        'options'   => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.2,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .footer-widget .title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .footer-widget .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .footer-widget .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .footer-widget .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      '_style_footer_contact',
      [
        'label' => esc_html__('Contact', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'heading_label',
      [
        'label'     => __('Content', 'tjcore'),
        'type'      => Controls_Manager::HEADING,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_label_typography',
        'selector' => '{{WRAPPER}} .footer-contact-info .contact-item span',
      ]
    );
    $this->add_control(
      'tj_label_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .footer-contact-info .contact-item span' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'tj_icon_color',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .footer-contact-info .contact-item span i' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'heading_phone',
      [
        'label'     => __('Link', 'tjcore'),
        'type'      => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_phone_typography',
        'selector' => '{{WRAPPER}} .footer-contact-info .contact-item a',
      ]
    );
    $this->add_control(
      'tj_phone_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .footer-contact-info .contact-item a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_phone_lcolor',
      [
        'label'     => __('Hover Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .footer-contact-info .contact-item a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {
    $settings         = $this->get_settings_for_display();
    $title            = $settings['tj_title'] ?? '';
    $contact_list     = $settings['tj_contact_list'] ?? [];

    $tjAnimation      = $settings['tj_animation'] ?? '';
    $tjAnimationName  = $settings['tj_animation_name'] ?? '';
    $tjAnimationDelay = $settings['tj_animation_delay']['size'] ?? '';

    $wrapClass = "footer-widget";

    if (!empty($tjAnimation) && !empty($tjAnimationName)) {
      $wrapClass .= " wow " . esc_attr($tjAnimationName);

      if (!empty($tjAnimationDelay)) {
        $this->add_render_attribute('tj_wrap_arg', 'data-wow-delay', esc_attr($tjAnimationDelay . "s"));
      }
    }

    $this->add_render_attribute('tj_wrap_arg', 'class', esc_attr($wrapClass));

    if (empty($contact_list)) {
      return;
    }
?>

    <div <?php echo $this->get_render_attribute_string('tj_wrap_arg'); ?>>
      <?php if (!empty($title)) : ?>
        <h5 class="title"><?php echo esc_html($title); ?></h5>
      <?php endif; ?>

      <div class="footer-contact-info">
        <?php foreach ($contact_list as $item) :
          $content = $item['tj_info_content'] ?? '';
        ?>
          <div class="contact-item">
            <?php echo tj_kses($content); ?>
          </div>
        <?php endforeach; ?>
      </div>
    </div>

<?php
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Footer_Contact());
