<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Repeater;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
  exit;
}

/**
 * Elementor widget for Funfact.
 */
class TJ_Counter_Loop extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-counter-loop';
  }

  // widget title.
  public function get_title()
  {
    return esc_html__('TJ Counter Loop', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-counter tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'counter',
      'counter up',
      'tj counter',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    // tj counter tab
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Counter Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          //2 => esc_html__('Style 02', 'tjcore'),
          //3 => esc_html__('Style 03', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_tab_tj_counter',
      [
        'label' => esc_html__('Counter', 'tjcore'),
      ]
    );

    $repeater = new Repeater();
    // title
    $repeater->add_control(
      'tj_ff_title',
      [
        'label'       => esc_html__('Counter Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => tj_kses('Counter Item #01'),
        'rows'        => '3',
      ]
    );
    // number
    $repeater->add_control(
      'tj_ff_number',
      [
        'label'       => esc_html__('Counter Amount', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => esc_html__('100', 'tjcore'),
      ]
    );
    // prefix
    $repeater->add_control(
      'tj_ff_prefix',
      [
        'label'       => esc_html__('Number Prefix', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'description' => esc_html__('Insert prefix for fact.', 'tjcore'),
      ]
    );
    // suffix
    $repeater->add_control(
      'tj_ff_suffix',
      [
        'label'       => esc_html__('Number Suffix', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'description' => esc_html__('Insert suffix for fact.', 'tjcore'),
        'default'     => tj_kses('+'),
      ]
    );

    $this->add_control(
      'tj_counter_list',
      [
        'label'    => esc_html__('Counter Items', 'tjcore'),
        'type'     => Controls_Manager::REPEATER,
        'fields'   => $repeater->get_controls(),
        'default'  => [
          [
            'tj_ff_title' => tj_kses('Projects Completed.'),
            'tj_ff_number' => esc_html__('800', 'tjcore'),
          ],
          [
            'tj_ff_title' => tj_kses('Combined Experience.'),
            'tj_ff_number' => esc_html__('20', 'tjcore'),
          ],
          [
            'tj_ff_title' => tj_kses('Using Over Colors.'),
            'tj_ff_number' => esc_html__('400', 'tjcore'),
          ],
          [
            'tj_ff_title' => tj_kses('Awards archived'),
            'tj_ff_number' => esc_html__('100', 'tjcore'),
          ]
        ],
        'title_field' => '{{{ tj_ff_title }}}',
      ]
    );

    $this->add_control(
      'tj_divider',
      [
        'label'        => esc_html__('Enable Divider?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );

    // animation
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // section style
    $this->tj_section_style_controls('counter_section', 'Section- Style', '.tj-el-section');

    // number style
    $this->tj_basic_style_controls('counter_number', 'Number - Style', '.tj-el-number');

    // title style
    $this->tj_basic_style_controls('counter_title', 'Title - Style', '.tj-el-title');
  }

  protected function render()
  {
    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/counter-loop/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}

$widgets_manager->register(new TJ_Counter_Loop());
