<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}

/**
 * Elementor widget for Button.
 */
class Tj_Button extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-button';
  }

  // widget title.
  public function get_title()
  {
    return esc_html__('TJ Button', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-button tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'button',
      'btn',
      'tj button',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {


    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Button Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      '__tj_button',
      [
        'label' => esc_html__('Button', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_btn_text',
      [
        'label'   => esc_html__('Text', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('Learn More', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'tj_btn_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_btn_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_btn_link_type' => '2',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'btn_icon',
        'default'          => [
          'value'   => 'tji-arrow-right-long',
          'library' => 'tj',
        ],
        'skin'             => 'inline',
        'label_block'      => true,
      ]
    );
    $this->add_responsive_control(
      'tj_align',
      [
        'label'        => esc_html__('Alignment', 'tjcore'),
        'type'         => Controls_Manager::CHOOSE,
        'options'      => [
          'start'   => [
            'title' => esc_html__('Left', 'tjcore'),
            'icon'  => 'eicon-text-align-left',
          ],
          'center' => [
            'title' => esc_html__('Center', 'tjcore'),
            'icon'  => 'eicon-text-align-center',
          ],
          'end'  => [
            'title' => esc_html__('Right', 'tjcore'),
            'icon'  => 'eicon-text-align-right',
          ],
        ],
        'default'      => 'center',
        'prefix_class' => 'tj_el_button elementor%s-align-',
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->tj_button_style_controls_two('button', 'Button - Style', '.tj-el-btn', '.btn-text');
    $this->tj_icon_style_controls_two('button_icon', 'Button Icon - Style', '.tj-el-btn', '.btn-icon');
  }

  protected function render()
  {
    $settings = $this->get_settings_for_display();

    $tj_design_style   = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/button/style-' . $tj_design_style . '.php';
  }
}

$widgets_manager->register(new Tj_Button());
