<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;



if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Brands Carousel.
 */
class TJ_Brand_Carousel extends Widget_Base
{
  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-brand-carousel';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Brand Carousel', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-carousel tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'brand',
      'brand carousel',
      'tj brand',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }


  /**
   * widget controls.
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Brand Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // tj_brands
    $this->start_controls_section(
      'tj_brands',
      [
        'label' => esc_html__('Partner Brands', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_title',
      [
        'label'     => esc_html__('Title', 'tjcore'),
        'type'      => Controls_Manager::TEXTAREA,
        'default'   => tj_kses('Join Over <span class="client-numbers">1000+</span> Companies with <span class="client-text">Bexon</span> Here', 'tjcore'),
        'rows'      => '3',
        'condition' => [
          'tj_design_style!' => ['2', '3', '4', '6', '5'],
        ],
      ]
    );

    $repeater = new Repeater();
    $repeater->add_control(
      'brand_image',
      [
        'label' => esc_html__('Image', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $this->add_control(
      'brands_items',
      [
        'label' => esc_html__('Brand Items', 'tjcore'),
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'brand_image' => Utils::get_placeholder_image_src(),
          ],
          [
            'brand_image' => Utils::get_placeholder_image_src(),
          ],
          [
            'brand_image' => Utils::get_placeholder_image_src(),
          ]
        ]
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    // carousel tab
    $this->start_controls_section(
      '__tj_carousel_settings',
      [
        'label' => esc_html__('Carousel Settings', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'slide_loop',
      [
        'label'             => esc_html__('Is Loop?', 'tjcore'),
        'type'              => Controls_Manager::SWITCHER,
        'label_on'          => esc_html__('Yes', 'tjcore'),
        'label_off'         => esc_html__('No', 'tjcore'),
        'description'       => esc_html__('Do you want to make this slider item loop?', 'tjcore'),
        'return_value'      => 'yes',
        'default'           => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay',
      [
        'label'             => esc_html__('Is Autoplay?', 'tjcore'),
        'type'              => Controls_Manager::SWITCHER,
        'label_on'          => esc_html__('Yes', 'tjcore'),
        'label_off'         => esc_html__('No', 'tjcore'),
        'description'       => esc_html__('Do you want to make this slider auto play?', 'tjcore'),
        'return_value'      => 'yes',
        'default'           => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay_delay',
      [
        'label' => esc_html__('Autoplay Delay', 'tjcore'),
        'type' => Controls_Manager::NUMBER,
        'description'       => esc_html__('Set slider autoplay delay.', 'tjcore'),
        'min' => 1,
        'max' => 10000,
        'step' => 100,
        'default' => 1,
        'condition' => [
          'slide_autoplay' => 'yes',
        ]
      ]
    );
    $this->end_controls_section();


    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // Circle style
    $this->tj_section_style_controls('cirlc_card', 'Circle- Style', '.tj-el-circle', ['2', '3', '4', '5', '6']);

    // title style
    $this->tj_basic_style_controls('title', 'Title - Style', '.tj-el-title', ['2', '3', '4', '5', '6']);

    $this->start_controls_section(
      'section_client_logo_style',
      [
        'label' => esc_html__('Client Logo', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    // Tabs: Normal / Hover
    $this->start_controls_tabs('tabs_client_logo_style');

    // Normal Tab
    $this->start_controls_tab(
      'tab_client_logo_normal',
      ['label' => esc_html__('Normal', 'tjcore')]
    );

    $this->add_control(
      'client_logo_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .client-logo' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'client_logo_border',
        'label' => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .client-logo',
      ]
    );
    $this->end_controls_tab();

    // Hover Tab
    $this->start_controls_tab(
      'tab_client_logo_hover',
      ['label' => esc_html__('Hover', 'tjcore')]
    );
    $this->add_control(
      'client_logo_bg_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .client-logo:hover' => 'background-color: {{VALUE}};',
          '{{WRAPPER}} .client-logo:hover::after' => 'background-color: {{VALUE}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'client_logo_border_hover',
        'label' => esc_html__('Border (Hover)', 'tjcore'),
        'selector' => '{{WRAPPER}} .client-logo:hover',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    // Padding
    $this->add_responsive_control(
      'client_logo_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .client-logo' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    // Border Radius
    $this->add_responsive_control(
      'client_logo_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors'  => [
          '{{WRAPPER}} .client-logo img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'client_logo_before_bg',
        'label'    => esc_html__('Background (Before)', 'tjcore'),
        'types'    => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .client-logo::before',
        'condition' => [
          'tj_design_style!' => ['2', '3', '4', '1'],
        ]
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style   = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/brand-carousel/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Brand_Carousel());
