<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Hero Banner.
 */
class TJ_Banner extends Widget_Base {

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name() {
    return 'tj-banner';
  }

  // widget title.
  public function get_title() {
    return __('TJ Banner', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-banner tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'hero',
      'hero banner',
      'tj hero',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Banner Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
          7 => esc_html__('Style 07', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // _tj_hero_banner_content
    $this->start_controls_section(
      '_tj_hero_banner_content',
      [
        'label' => esc_html__('Banner Content', 'tjcore'),
      ]
    );

    $this->add_control(
      'tj_subtitle',
      [
        'label'       => esc_html__('Subtitle', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('100% WORKMANSHIP GUARANTEE', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'subtitle_icon_show',
      [
        'label'        => esc_html__('Enable Subtitle Icon?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '',
      ]
    );
    $this->add_control(
      'tj_subtitle_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-excellence',
          'library' => 'tj',
        ],
        'skin' => 'inline',
        'label_block' => false,
        'condition' => [
          'subtitle_icon_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_subtitle_animation',
      [
        'label'        => esc_html__('Enable Subtitle Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '',
      ]
    );
    $this->add_control(
      'tj_subtitle_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_subtitle_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_subtitle_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_subtitle_animation' => 'yes',
        ],
      ]
    );

    $this->add_control(
      'tj_title',
      [
        'label'     => esc_html__('Title', 'tjcore'),
        'type'      => Controls_Manager::TEXTAREA,
        'default'   => esc_html__('Expert Electrical Service for Home and Business.', 'tjcore'),
        'rows'      => '3',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_gsap_animation',
      [
        'label'        => esc_html__('Enable GSAP Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'animation_type',
      [
        'label' => esc_html__('Animation type', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => 'title-anim',
        'options' => [
          'title-anim' => esc_html__('Split Text 1', 'tjcore'),
          'text-anim' => esc_html__('Split Text 2', 'tjcore'),
          'title-highlight'  => esc_html__('Title Highlight', 'tjcore'),
        ],
        'condition' => [
          'tj_gsap_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_title_animation',
      [
        'label'        => esc_html__('Enable Title Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '',
      ]
    );
    $this->add_control(
      'tj_title_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_title_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_title_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_title_animation' => 'yes',
        ],
      ]
    );

    // title tag
    $this->add_control(
      'tj_title_tag',
      [
        'label'     => esc_html__('Title HTML Tag', 'tjcore'),
        'type'      => Controls_Manager::CHOOSE,
        'options'   => [
          'h1' => [
            'title' => esc_html__('H1', 'tjcore'),
            'icon'  => 'eicon-editor-h1',
          ],
          'h2' => [
            'title' => esc_html__('H2', 'tjcore'),
            'icon'  => 'eicon-editor-h2',
          ],
          'h3' => [
            'title' => esc_html__('H3', 'tjcore'),
            'icon'  => 'eicon-editor-h3',
          ],
          'h4' => [
            'title' => esc_html__('H4', 'tjcore'),
            'icon'  => 'eicon-editor-h4',
          ],
          'h5' => [
            'title' => esc_html__('H5', 'tjcore'),
            'icon'  => 'eicon-editor-h5',
          ],
          'h6' => [
            'title' => esc_html__('H6', 'tjcore'),
            'icon'  => 'eicon-editor-h6',
          ],
        ],
        'default'   => 'h1',
        'toggle'    => false,
        'separator' => 'before',
      ]
    );

    // desc
    $this->add_control(
      'tj_banner_desc',
      [
        'label' => esc_html__('Description', 'tjcore'),
        'type' => Controls_Manager::TEXTAREA,
        'rows' => 6,
        'default' => esc_html__('Discover the Difference with Electric Services. Your Trusted Local Experts in Electrical Contracting.', 'tjcore'),
        'placeholder' => esc_html__('Type your description here', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ['2']
        ]
      ]
    );
    // desc animation
    $this->add_control(
      'tj_desc_animation',
      [
        'label'        => esc_html__('Enable Description Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '',
        'condition' => [
          'tj_design_style!' => ['2']
        ]
      ]
    );
    $this->add_control(
      'tj_desc_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition'  => [
          'tj_desc_animation' => 'yes',
          'tj_design_style!' => ['2']
        ],
      ]
    );
    $this->add_control(
      'tj_desc_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_desc_animation' => 'yes',
          'tj_design_style!' => ['2']
        ],
      ]
    );

    // scroll down
    $this->add_control(
      'tj_scroll_down_show',
      [
        'label'        => esc_html__('Show scroll down?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '',
        'separator' => 'before',
        'condition'  => [
          'tj_design_style!' => ['4', '5', '7']
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_scroll_text',
      [
        'label'  => esc_html__('Scroll Text', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('Scroll Down', 'tjcore'),
        'condition' => [
          'tj_scroll_down_show' => 'yes',
          'tj_design_style!' => ['4', '5', '7']
        ]
      ]
    );
    $this->add_control(
      'tj_banner_scroll_link',
      [
        'label' => esc_html__('Scroll Link', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_attr("#"),
        'label_block' => true,
        'condition' => [
          'tj_scroll_down_show' => 'yes',
          'tj_design_style!' => ['4', '5', '7']
        ]
      ]
    );
    $this->end_controls_section();

    // button    
    $this->start_controls_section(
      'tj_hero_btn',
      [
        'label'     => esc_html__('Button', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_button_show',
      [
        'label'        => esc_html__('Show button?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '',
      ]
    );
    $this->add_control(
      'tj_btn_image',
      [
        'label' => esc_html__('Button Image', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'condition' => [
          'tj_button_show' => 'yes',
          'tj_design_style!' => ['1', '2', '3', '5', '6', '7']
        ],
      ]
    );
    $this->add_control(
      'tj_btn_text',
      [
        'label'     => esc_html__('Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('Learn More', 'tjcore'),
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_button_show' => 'yes',
          'tj_design_style!' => ['1', '4']
        ],
      ]
    );
    $this->add_control(
      'tj_btn_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-arrow-right-big',
          'library' => 'tj',
        ],
        'skin' => 'inline',
        'fa4compatibility' => 'btn_icon',
        'label_block' => false,
        'condition' => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
        'separator' => 'before',
        'condition' => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_button_show' => 'yes',
          'tj_btn_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_button_show'  => 'yes',
          'tj_btn_link_type' => '2',
        ],
      ]
    );
    // btn animation
    $this->add_control(
      'tj_button_animation',
      [
        'label'        => esc_html__('Enable Button Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
        'condition'    => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_button_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_button_show'      => 'yes',
          'tj_button_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_button_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_button_show'      => 'yes',
          'tj_button_animation' => 'yes',
        ],
      ]
    );

    // contact button
    $this->add_control(
      'tj_contact_button_show',
      [
        'label'        => esc_html__('Show contact button?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'separator' => 'before',
        'condition' => [
          'tj_design_style!' => ['1', '3', '4', '5', '6', '7'],
        ],
      ]
    );
    $this->add_control(
      'tj_contact_btn_text',
      [
        'label'     => esc_html__('Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('1-888-452-1505', 'tjcore'),
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_contact_button_show' => 'yes',
          'tj_design_style!' => ['1', '3', '4', '5', '6', '7'],
        ],
      ]
    );
    $this->add_control(
      'tj_contact_btn_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-phone',
          'library' => 'tj',
        ],
        'skin' => 'inline',
        'fa4compatibility' => 'contact_btn_icon',
        'label_block' => false,
        'condition' => [
          'tj_contact_button_show' => 'yes',
          'tj_design_style!' => ['1', '3', '4', '5', '6', '7'],
        ],
      ]
    );
    $this->add_control(
      'tj_contact_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => esc_attr("tel:18884521505"),
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_contact_button_show' => 'yes',
          'tj_design_style!' => ['1', '3', '4', '5', '6', '7'],
        ],
        'label_block' => true,
      ]
    );
    // btn animation
    $this->add_control(
      'tj_contact_button_animation',
      [
        'label'        => esc_html__('Enable Contact Button Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
        'condition'    => [
          'tj_contact_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_contact_button_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_contact_button_show'      => 'yes',
          'tj_contact_button_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_contact_button_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_contact_button_show'      => 'yes',
          'tj_contact_button_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();


    // thumbnails
    $this->start_controls_section(
      'tj_hero_thumbnails',
      [
        'label'     => esc_html__('Thumbnails', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ['7']
        ]
      ]
    );
    $this->add_control(
      'tj_banner_image',
      [
        'label' => esc_html__('Banner Image', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $this->add_control(
      'tj_banner_bgimage',
      [
        'label' => esc_html__('Banner BG Image', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style!' => ['2', '3', '7']
        ]
      ]
    );
    $this->add_control(
      'tj_brand_name',
      [
        'label'     => esc_html__('Brand Name', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('Bexon', 'tjcore'),
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_design_style!' => ['1', '3', '4', '5', '6', '7']
        ]
      ]
    );
    $this->add_control(
      'tj_banner_growth_img',
      [
        'label' => esc_html__('Growth Image', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'condition' => [
          'tj_design_style!' => ['1', '3', '4', '5', '6', '7'],
        ]
      ]
    );

    $this->add_control(
      'tj_img_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '',
        'separator'    => 'before',
        'condition' => [
          'tj_design_style!' => ['3', '7']
        ]
      ]
    );
    $this->add_control(
      'tj_img_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUpBig' => esc_html__('Fade In RightBig', 'tjcore'),
        ],
        'condition' => [
          'tj_img_animation' => 'yes',
          'tj_design_style!' => ['3', '7']
        ],
      ]
    );
    $this->add_control(
      'tj_img_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_img_animation' => 'yes',
          'tj_design_style!' => ['3', '7']
        ],
      ]
    );
    $this->end_controls_section();

    // Counter + Client
    $this->start_controls_section(
      'tj_customer_tab',
      [
        'label' => esc_html__('Box Content', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_custom_html',
      [
        'label'     => esc_html__('Custom HTML', 'tjcore'),
        'type'      => Controls_Manager::TEXTAREA,
        'default'   => esc_html__('', 'tjcore'),
        'row' => 3,
        'condition' => [
          'tj_design_style!' => ['2']
        ]
      ]
    );
    $this->add_control(
      'tj_number',
      [
        'label'     => esc_html__('Counter Number', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('30', 'tjcore'),
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_design_style!' => ['2', '4', '5', '6', '7']
        ]
      ]
    );
    $this->add_control(
      'tj_suffix',
      [
        'label'     => esc_html__('Counter Suffix', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('K', 'tjcore'),
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_design_style!' => ['2', '4', '5', '6', '7']
        ]
      ]
    );
    $this->add_control(
      'tj_counter_title',
      [
        'label'     => esc_html__('Counter Title', 'tjcore'),
        'label_block' => true,
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('Happy customer we have world-wide.', 'tjcore'),
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_design_style!' => ['2', '5', '6', '7']
        ]
      ]
    );
    $this->add_control(
      'tj_client_name',
      [
        'label'     => esc_html__('Name', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('Eade Marren', 'tjcore'),
        'label_block'   => true,
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_design_style!' => ['1', '3', '4', '5', '6', '7']
        ]
      ]
    );
    $this->add_control(
      'tj_client_designation',
      [
        'label'     => esc_html__('Designation', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('CEO & Founder', 'tjcore'),
        'label_block'   => true,
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_design_style!' => ['1', '3', '4', '5', '6', '7']
        ]
      ]
    );
    $this->add_control(
      'counter_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'counter_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'counter_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'counter_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'counter_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    // Shape Image
    $this->start_controls_section(
      'tj_shape_img_tab',
      [
        'label' => esc_html__('Shape Image', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ['1', '5']
        ]
      ]
    );
    $this->add_control(
      'tj_banner_left_shape',
      [
        'label' => esc_html__('Left Shape', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
      ]
    );
    $this->add_control(
      'tj_banner_right_shape',
      [
        'label' => esc_html__('Right Shape', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'tj_video_tab',
      [
        'label' => esc_html__('Video Content', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ['1', '2', '3', '4', '5', '6']
        ]
      ]
    );

    $this->add_control(
      'video_link',
      [
        'label' => esc_html__('Video URL', 'tjcore'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => esc_html__('Enter your URL', 'tjcore'),
        'autocomplete' => false,
        'options' => false,
        'label_block' => true,
      ]
    );

    $this->add_control(
      'video_autoplay',
      [
        'label' => esc_html__('Auto play', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('On', 'tjcore'),
        'label_off' => esc_html__('Off', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );

    $this->add_control(
      'video_controler',
      [
        'label' => esc_html__('Controler', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('On', 'tjcore'),
        'label_off' => esc_html__('Off', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );

    $this->add_control(
      'video_loop',
      [
        'label' => esc_html__('Loop', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('On', 'tjcore'),
        'label_off' => esc_html__('Off', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );

    $this->add_control(
      'video_muted',
      [
        'label' => esc_html__('Muted', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('On', 'tjcore'),
        'label_off' => esc_html__('Off', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );

    $this->add_control(
      'video_image',
      [
        'label' => esc_html__('Choose Poster', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // section style
    $this->tj_section_style_controls('section', 'Section - Style', '.tj-el-section');

    // subtitle style
    $this->tj_basic_style_controls('sub_title', 'Sub Title - Style', '.tj-el-subtitle');

    // title style
    $this->tj_basic_style_controls('title', 'Title - Style', '.tj-el-title');

    // description style
    $this->tj_basic_style_controls('desc', 'Description - Style', '.tj-el-desc', ['2']);

    // button style
    $this->tj_button_style_controls_two('button', 'Button - Style', '.tj-primary-btn', '.btn-text', ['1', '4', '5']);
    $this->tj_icon_style_controls_two('button_icon', 'Button Icon - Style', '.tj-primary-btn', '.btn-icon', ['1', '4', '5']);
    $this->tj_button_style_controls('phone', 'Phone - Style', '.btn-area .number', ['1', '3', '4', '5', '6', '7']);

    // icon button style
    $this->tj_icon_style_controls('btn_icon', 'Button Icon - Style', '.tj-el-icon', ['2', '3', '6', '7']);
    $this->tj_button_style_controls_two('button2', 'Button - Style', '.tj-el-icon', '.desc', ['1', '2', '3', '4', '6', '7']);


    // social icons
    $this->tj_icon_style_controls('socail_icon', 'Social Icon - Style', '.tj-el-icon ul li a', ['1', '2', '3', '4', '5', '7']);


    // scroll down style
    $this->tj_basic_style_controls('scroll_text', 'Scroll Text - Style', '.scroll-down', ['4', '5', '6', '7']);
    $this->tj_icon_style_controls_two('scroll_icon', 'Scroll Icon - Style', '.scroll-down', '.icon', ['4', '5', '6', '7']);

    // card style
    $this->tj_card_style_controls('counter_card', 'Card- Style', '.tj-el-box', ['2', '4', '5', '6']);

    // number style
    $this->tj_basic_style_controls('counter_number', 'Counter Number - Style', '.tj-el-number', ['2', '4', '5', '6', '7']);
    $this->tj_basic_style_controls('counter_text', 'Counter text - Style', '.tj-el-text', ['2', '5', '6', '7']);

    // image box style
    $this->tj_section_style_controls('image_wrap', 'Image Wrap - Style', '.tj-el-image-box', ['3']);
    $this->tj_img_style_controls('banner_image', 'Image - Style', '.tj-el-image-box', ['3', '7']);

    // auhtor style
    $this->tj_basic_style_controls('client_name', 'Author Name - Style', '.tj-el-name', ['1', '3', '4', '5', '6', '7']);
    $this->tj_basic_style_controls('client_text', 'Author Degisnation - Style', '.tj-el-job', ['1', '3', '4', '5', '6', '7']);

    //Circle + brand name
    $this->start_controls_section(
      '_style_content_Circle',
      [
        'label' => esc_html__('Brand Name Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1', '3', '4', '5', '6', '7']
        ]
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_brand_name_typography',
        'selector' => '{{WRAPPER}} .tj-banner-section-2 .banner-img .brand-name',
      ]
    );

    $this->add_control(
      'tj_brand_name_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-banner-section-2 .banner-img .brand-name' => '-webkit-text-fill-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'tj_Circle_background',
        'selector' => '{{WRAPPER}} .tj-banner-section-2 .banner-img-area::before',
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_banner_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/banner/style-' . $tj_banner_style . '.php';
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Banner());
