<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Repeater;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Accordion.
 */
class TJ_Accordion extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-accordion';
  }

  // widget title.
  public function get_title() {
    return __('TJ Accordion', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-accordion tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'accordion',
      'accordions',
      'tj accordion',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Accordion Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();
    // Accordion items
    $this->start_controls_section(
      'tj_accordion_content',
      [
        'label' => esc_html__('Accordion Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'tj_accordion_question',
      [
        'label'       => esc_html__('Question', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'rows' => 2,
      ]
    );
    $repeater->add_control(
      'is_expand',
      [
        'label'             => esc_html__('Is Expand?', 'tjcore'),
        'type'              => Controls_Manager::SWITCHER,
        'label_on'          => esc_html__('Yes', 'tjcore'),
        'label_off'         => esc_html__('No', 'tjcore'),
        'description'       => esc_html__('Do you want to make this item expand?', 'tjcore'),
        'return_value'      => 'yes',
        'default'           => 'no',
      ]
    );
    $repeater->add_control(
      'tj_accordion_answer',
      [
        'label'       => esc_html__('Answer', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
      ]
    );

    // animation
    $repeater->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $repeater->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => 'fadeInUp',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $repeater->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ]
      ]
    );


    $this->add_control(
      'tj_accordion_list',
      [
        'label'       => esc_html__('Accordion - List', 'tjcore'),
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater->get_controls(),
        'default'     => [
          [
            'tj_accordion_question' => esc_html__('What services does Bexon offer to clients?', 'tjcore'),
            'tj_accordion_answer'   => esc_html__("Getting started is easy! Simply reach out to us through our contact form or give us a call, and we’ll schedule a consultation to discuss your project and how we can best assist you. Our team keeps you informed throughout the process, ensuring quality control and timely delivery."),
          ],
          [
            'tj_accordion_question' => esc_html__('How do I get started with Corporate Business?', 'tjcore'),
            'tj_accordion_answer'   => esc_html__("Getting started is easy! Simply reach out to us through our contact form or give us a call, and we’ll schedule a consultation to discuss your project and how we can best assist you. Our team keeps you informed throughout the process, ensuring quality control and timely delivery."),
          ],
          [
            'tj_accordion_question' => esc_html__('How do you ensure the success of a project?', 'tjcore'),
            'tj_accordion_answer'   => esc_html__("Getting started is easy! Simply reach out to us through our contact form or give us a call, and we’ll schedule a consultation to discuss your project and how we can best assist you. Our team keeps you informed throughout the process, ensuring quality control and timely delivery."),
          ],
          [
            'tj_accordion_question' => esc_html__('How long will it take to complete my project?', 'tjcore'),
            'tj_accordion_answer'   => esc_html__("Getting started is easy! Simply reach out to us through our contact form or give us a call, and we’ll schedule a consultation to discuss your project and how we can best assist you. Our team keeps you informed throughout the process, ensuring quality control and timely delivery."),
          ],
          [
            'tj_accordion_question' => esc_html__('Can I track the progress of my project?', 'tjcore'),
            'tj_accordion_answer'   => esc_html__("Getting started is easy! Simply reach out to us through our contact form or give us a call, and we’ll schedule a consultation to discuss your project and how we can best assist you. Our team keeps you informed throughout the process, ensuring quality control and timely delivery."),
          ],
        ],
        'title_field' => '{{{ tj_accordion_question }}}',
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->start_controls_section(
      'section_style_accordion_wrapper',
      [
        'label' => esc_html__('Accordion Item', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    // Start tabs for Normal and Active states
    $this->start_controls_tabs('tabs_accordion_wrapper_states');

    /** Normal State Tab */
    $this->start_controls_tab(
      'tab_accordion_wrapper_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'accordion_wrapper_background_normal',
        'label'    => esc_html__('Background', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item',
        'exclude'  => ['image', 'video'],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'accordion_wrapper_border_normal',
        'label'    => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item',
      ]
    );

    $this->end_controls_tab();

    /** Active State Tab */
    $this->start_controls_tab(
      'tab_accordion_wrapper_active',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'accordion_wrapper_background_active',
        'label'    => esc_html__('Background', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item.active',
        'exclude'  => ['image', 'video'],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'accordion_wrapper_border_active',
        'label'    => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item.active',
      ]
    );

    $this->end_controls_tab();

    $this->end_controls_tabs();

    // Box shadow (applies to both states, but you can separate if needed)
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'accordion_wrapper_box_shadow',
        'label'    => esc_html__('Box Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item',
      ]
    );

    // Border radius
    $this->add_responsive_control(
      'accordion_wrapper_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before',
      ]
    );

    // Padding
    $this->add_responsive_control(
      'accordion_wrapper_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    // Margin
    $this->add_responsive_control(
      'accordion_wrapper_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();


    $this->start_controls_section(
      'section_style_accordion_title',
      [
        'label' => esc_html__('Accordion Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    // Typography control for accordion title
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'accordion_title_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item .faq-title',
      ]
    );

    // Tabs for Normal and Active states styling
    $this->start_controls_tabs('tabs_accordion_title_states');

    // Normal state tab
    $this->start_controls_tab(
      'tab_accordion_title_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );

    $this->add_control(
      'accordion_title_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-item .faq-title' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'accordion_title_background_normal',
        'label'    => esc_html__('Background', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item .faq-title',
        'exclude'  => ['image', 'video'],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'accordion_title_border',
        'label'    => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item .faq-title',
      ]
    );

    $this->end_controls_tab();

    // Active state tab
    $this->start_controls_tab(
      'tab_accordion_title_active',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );

    $this->add_control(
      'accordion_title_color_active',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-item.active .faq-title' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'accordion_title_background_active',
        'label'    => esc_html__('Background', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item.active .faq-title',
        'exclude'  => ['image', 'video'],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'accordion_title_border_active',
        'label'    => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item.active .faq-title',
      ]
    );

    $this->end_controls_tab();

    $this->end_controls_tabs();

    // Border radius
    $this->add_responsive_control(
      'accordion_title_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-item .faq-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before',
      ]
    );

    // Responsive padding control
    $this->add_responsive_control(
      'accordion_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-item .faq-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    // Responsive margin control
    $this->add_responsive_control(
      'accordion_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-item .faq-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
      'section_style_accordion_icon',
      [
        'label' => esc_html__('Accordion Icon', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    // Icon font size
    $this->add_control(
      'accordion_icon_font_size',
      [
        'label' => esc_html__('Icon Font Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem'],
        'range' => [
          'px' => ['min' => 0, 'max' => 100],
        ],
        'selectors' => [
          '{{WRAPPER}} .accordion-item .faq-title::after' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    // Start Normal / Active Tabs
    $this->start_controls_tabs('tabs_accordion_icon_states');

    /** Normal Tab */
    $this->start_controls_tab(
      'tab_accordion_icon_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );

    $this->add_control(
      'accordion_icon_color_normal',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-item .faq-title::after' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'accordion_icon_bgcolor_normal',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-item .faq-title::after' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'accordion_icon_border_normal',
        'selector' => '{{WRAPPER}} .accordion-item .faq-title::after',
      ]
    );

    $this->end_controls_tab();

    /** Active Tab */
    $this->start_controls_tab(
      'tab_accordion_icon_active',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );

    $this->add_control(
      'accordion_icon_color_active',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-item.active .faq-title::after' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'accordion_icon_bgcolor_active',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-item.active .faq-title::after' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'accordion_icon_border_active',
        'selector' => '{{WRAPPER}} .accordion-item.active .faq-title::after',
      ]
    );

    $this->end_controls_tab();

    $this->end_controls_tabs(); // End of Tabs

    $this->add_responsive_control(
      'accordion_icon_width_normal',
      [
        'label' => esc_html__('Width', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .accordion-item .faq-title::after' => 'width: {{SIZE}}{{UNIT}};',
        ],
        'separator' => 'before',
      ]
    );

    $this->add_responsive_control(
      'accordion_icon_height_normal',
      [
        'label' => esc_html__('Height', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .accordion-item .faq-title::after' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'accordion_icon_border_radius',
      [
        'label' => esc_html__('Border Radius', 'tjcore'),
        'type'  => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
          '{{WRAPPER}} .accordion-item .faq-title::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section(); // End of Section

    // content
    $this->start_controls_section(
      'section_style_accordion_content',
      [
        'label' => esc_html__('Accordion Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    // Typography control for accordion title
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'accordion_content_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item .accordion-body p',
      ]
    );

    // Tabs for Normal and Active states styling
    $this->start_controls_tabs('tabs_accordion_content_states');

    // Normal state tab
    $this->start_controls_tab(
      'tab_accordion_content_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );

    $this->add_control(
      'accordion_content_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-item .accordion-body p' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'accordion_content_background_normal',
        'label'    => esc_html__('Background', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item .accordion-body p',
        'exclude'  => ['image', 'video'],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'accordion_content_border',
        'label'    => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item .accordion-body p',
      ]
    );

    $this->end_controls_tab();

    // Active state tab
    $this->start_controls_tab(
      'tab_accordion_content_active',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );

    $this->add_control(
      'accordion_content_color_active',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-item.active .accordion-body p' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'accordion_content_background_active',
        'label'    => esc_html__('Background', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item.active .accordion-body p',
        'exclude'  => ['image', 'video'],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'accordion_content_border_active',
        'label'    => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .accordion-item.active .accordion-body p',
      ]
    );

    $this->end_controls_tab();

    $this->end_controls_tabs();

    // Border radius
    $this->add_responsive_control(
      'accordion_content_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-item .accordion-body p' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before',
      ]
    );

    // Responsive padding control
    $this->add_responsive_control(
      'accordion_content_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-item .accordion-body p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    // Responsive margin control
    $this->add_responsive_control(
      'accordion_content_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-item .accordion-body p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/accordion/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Accordion());
