<?php
$tj_video_icon = $settings['tj_video_icon'] ?? "";
$tj_video_link = $settings['tj_video_link'] ?? "";
$tj_video_title = $settings['tj_video_title'] ?? "";

// Animation
$tjAnimation       = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

// Setting animation attributes
$class = "tj-video-button";
if ($tjAnimation === 'yes' && !empty($tjAnimationName)) {
  $class .= " wow $tjAnimationName";
  $this->add_render_attribute('tj_video_args', 'data-wow-delay', $tjAnimationDelay . 's');
}
$this->add_render_attribute('tj_video_args', 'class', $class);
?>

<div <?php echo $this->get_render_attribute_string('tj_video_args'); ?>>
  <?php if (!empty($tj_video_link)): ?>
    <a class="h9-about-video-btn video-popup" href="<?php echo esc_url($tj_video_link); ?>">
      <?php if (!empty($tj_video_icon['value'])): ?>
        <span class="play-btn"> <?php tj_render_icon($settings, 'video_icon', 'tj_video_icon'); ?></span>
      <?php endif; ?>
      <?php if (!empty($tj_video_title)): ?>
        <span class="video-text"><?php echo tj_kses($tj_video_title); ?></span>
      <?php endif; ?>
    </a>
  <?php endif; ?>
</div>