<?php

$timelines = !empty($settings['tj_timeline_list']) ? $settings['tj_timeline_list'] : [];

?>

<?php if (count($timelines) > 0): ?>
  <div class="timeline">
    <?php foreach ($timelines as $item):
      $tj_tm_year = (!empty($item['tj_tm_year'])) ? $item['tj_tm_year'] : "";
      $tj_tm_number = (!empty($item['tj_tm_number'])) ? $item['tj_tm_number'] : "";
      $tj_tm_title = (!empty($item['tj_tm_title'])) ? $item['tj_tm_title'] : "";
      $tj_tm_desc = (!empty($item['tj_tm_desc'])) ? $item['tj_tm_desc'] : "";
      $tj_tm_image = (!empty($item['tj_tm_image'])) ? $item['tj_tm_image'] : "";
      $tj_tm_image2 = (!empty($item['tj_tm_image2'])) ? $item['tj_tm_image2'] : "";

      // animation
      $tjAnimation = $item['tj_animation'] ?? '';
      $tjAnimationName = $item['tj_animation_name'] ?? '';
      $tjAnimationDelay = $item['tj_animation_delay'] ?? '';

      $timelineClass = "timeline-inner";
      if (!empty($tjAnimation)) {
        $timelineClass .= " wow $tjAnimationName";
        $this->add_render_attribute('tj-wrap-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
      }
      $this->add_render_attribute('tj-wrap-arg', 'class', $timelineClass);


    ?>
      <div <?php echo $this->get_render_attribute_string('tj-wrap-arg'); ?>>
        <?php if (!empty($tj_tm_year)): ?>
          <div class="date"><?php echo tj_kses($tj_tm_year); ?></div>
        <?php endif; ?>
        <div class="content">
          <div class="top">
            <?php if (!empty($tj_tm_number)): ?>
              <span><?php echo tj_kses($tj_tm_number); ?></span>
            <?php endif; ?>
            <?php if (!empty($tj_tm_title)): ?>
              <h4 class="title"><?php echo tj_kses($tj_tm_title); ?></h4>
            <?php endif; ?>
            <?php if (!empty($tj_tm_desc)): ?>
              <p><?php echo tj_kses($tj_tm_desc); ?></p>
            <?php endif; ?>
          </div>
          <?php if (!empty($tj_tm_image['url']) || !empty($tj_tm_image2['url'])) : ?>
            <div class="bottom">
              <?php if (!empty($tj_tm_image['url'])) : ?>
                <img src="<?php echo esc_url($tj_tm_image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tj_tm_image['id'], '_wp_attachment_image_alt', true)); ?>">
              <?php endif; ?>
              <?php if (!empty($tj_tm_image2['url'])) : ?>
                <img src="<?php echo esc_url($tj_tm_image2['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tj_tm_image2['id'], '_wp_attachment_image_alt', true)); ?>">
              <?php endif; ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>