<?php
$memberImage = $settings['tj_image'] ?? "";
$memberName = $settings['tj_name'] ?? "";
$memberDesignation = $settings['tj_designation'] ?? "";
$memberUrl = $settings['tj_url'] ?? "";

if (! empty($memberUrl['url'])) {
  $this->add_link_attributes('link', $memberUrl);
}

$showMediaLink = $settings['tj_media_link'] ?? "";
$showNameLink = $settings['tj_name_link'] ?? "";
$showButton = $settings['tj_show_button'] ?? "";
$buttonText = $settings['tj_button_text'] ?? "";
$buttonIcon = $settings['tj_btn_icon'] ?? "";

$showMemberSocials = $settings['tj_show_member_socials'] ?? false;
$memberWebsite = $settings['tj_website_link'] ?? "";
$memberEmail = $settings['tj_email_link'] ?? "";
$memberPhone = $settings['tj_phone_link'] ?? "";
$memberFacebook = $settings['tj_facebook_link'] ?? "";
$memberTwitter = $settings['tj_twitter_link'] ?? "";
$memberInstagram = $settings['tj_instagram_link'] ?? "";
$memberLinkedin = $settings['tj_linkedin_link'] ?? "";
$memberPinterest = $settings['tj_pinterest_link'] ?? "";
$memberYoutube = $settings['tj_youtube_link'] ?? "";
$memberVimeo = $settings['tj_vimeo_link'] ?? "";
$memberGithub = $settings['tj_github_link'] ?? "";
$memberFlickr = $settings['tj_flickr_link'] ?? "";
$memberBehance = $settings['tj_behance_link'] ?? "";
$memberDribbble =  $settings['tj_dribbble_link'] ?? "";

$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$teamClass = "h8-team-item-wrapper tj-el-team";
if (!empty($tjAnimation)) {
  $teamClass .= " wow $tjAnimationName";
  $this->add_render_attribute('team_arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('team_arg', 'class', $teamClass);
?>

<div <?php $this->print_render_attribute_string('team_arg'); ?>>
  <div class="team-item box">
    <div class="team-img">

      <?php if (!empty($memberImage['url'])): ?>
        <!-- image -->
        <div class="team-img-inner">
          <?php if ("yes" == $showMediaLink && !empty($memberUrl['url'])): ?>
            <a <?php $this->print_render_attribute_string('link'); ?>>
              <img src="<?php echo esc_url($memberImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($memberImage['id'], '_wp_attachment_image_alt', true)); ?>">
            </a>
          <?php else: ?>
            <img src="<?php echo esc_url($memberImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($memberImage['id'], '_wp_attachment_image_alt', true)); ?>">
          <?php endif; ?>
        </div>
      <?php endif; ?>

      <?php if ('yes' === $showMemberSocials): ?>
        <div class="social-links">
          <ul>
            <?php if (!empty($memberWebsite)) : ?>
              <li>
                <a href="<?php echo esc_attr($memberWebsite); ?>">
                  <i class="fa-solid fa-globe"></i>
                </a>
              </li>
            <?php endif;

            if (!empty($memberPhone)) : ?>
              <li>
                <a href="<?php echo esc_attr($memberPhone); ?>">
                  <i class="fa-solid fa-phone"></i>
                </a>
              </li>
            <?php endif;

            if (!empty($memberFacebook)) : ?>
              <li>
                <a href="<?php echo esc_attr($memberFacebook); ?>">
                  <i class="fa-brands fa-facebook-f"></i>
                </a>
              </li>
            <?php endif;

            if (!empty($memberTwitter)) : ?>
              <li>
                <a href="<?php echo esc_attr($memberTwitter); ?>">
                  <i class="fa-brands fa-twitter"></i>
                </a>
              </li>
            <?php endif;

            if (!empty($memberInstagram)) : ?>
              <li>
                <a href="<?php echo esc_attr($memberInstagram); ?>">
                  <i class="fa-brands fa-instagram"></i>
                </a>
              </li>
            <?php endif;

            if (!empty($memberLinkedin)) : ?>
              <li>
                <a href="<?php echo esc_attr($memberLinkedin); ?>">
                  <i class="fa-brands fa-linkedin-in"></i>
                </a>
              </li>
            <?php endif;

            if (!empty($memberPinterest)) :  ?>
              <li>
                <a href="<?php echo esc_attr($memberPinterest); ?>">
                  <i class="fa-brands fa-pinterest"></i>
                </a>
              </li>
            <?php endif;

            if (!empty($memberYoutube)) : ?>
              <li>
                <a href="<?php echo esc_attr($memberYoutube); ?>">
                  <i class="fa-brands fa-youtube"></i>
                </a>
              </li>
            <?php endif;

            if (!empty($memberVimeo)) : ?>
              <li>
                <a href="<?php echo esc_attr($memberVimeo); ?>">
                  <i class="fab fa-vimeo"></i>
                </a>
              </li>
            <?php endif;

            if (!empty($memberGithub)) : ?>
              <li>
                <a href="<?php echo esc_attr($memberGithub); ?>">
                  <i class="fab fa-github"></i>
                </a>
              </li>
            <?php endif;

            if (!empty($memberFlickr)) : ?>
              <li>
                <a href="<?php echo esc_attr($memberFlickr); ?>">
                  <i class="fab fa-flickr"></i>
                </a>
              </li>
            <?php endif;

            if (!empty($memberBehance)) : ?>
              <li>
                <a href="<?php echo esc_attr($memberBehance); ?>">
                  <i class="fab fa-behance"></i>
                </a>
              </li>
            <?php endif;

            if (!empty($memberDribbble)) : ?>
              <li>
                <a href="<?php echo esc_attr($memberDribbble); ?>">
                  <i class="fab fa-dribbble"></i>
                </a>
              </li>
            <?php endif; ?>
          </ul>
        </div>
      <?php endif; ?>
    </div>

    <div class="team-content">

      <?php if (!empty($memberName)): ?>
        <!-- name -->
        <h5 class="title">
          <?php if ("yes" == $showNameLink && !empty($memberUrl['url'])): ?>
            <a <?php $this->print_render_attribute_string('link'); ?>>
              <?php echo tj_kses($memberName); ?>
            </a>
          <?php else: ?>
            <?php echo tj_kses($memberName); ?>
          <?php endif; ?>
        </h5>
      <?php endif; ?>

      <?php if (!empty($memberDesignation)): ?>
        <!-- designation -->
        <span class="designation"><?php echo esc_html__($memberDesignation, 'tjcore'); ?></span>
      <?php endif; ?>

      <?php if ("yes" == $showButton && !empty($memberUrl['url'])): ?>
        <!-- button -->
        <a class="team_btn text-btn tj-el-btn" <?php $this->print_render_attribute_string('link'); ?>>
          <span class="btn-text"><span><?php echo tj_kses($buttonText); ?></span></span>
          <?php if (!empty($buttonIcon['value'])): ?>
            <span class="btn-icon">
              <?php \Elementor\Icons_Manager::render_icon($buttonIcon, ['aria-hidden' => 'true']); ?>
            </span>
          <?php endif; ?>
        </a>
      <?php endif; ?>
    </div>
  </div>
</div>