<?php
$teamMembers = $settings['team_member2_list'] ?? "";
?>

<?php if (!empty($teamMembers)): ?>
  <div class="h9-team-item-wrap">


    <?php foreach ($teamMembers as $key => $member) :
      $memberImage = $member['tj_member2_image'] ?? "";
      $memberName = $member['tj_member2_name'] ?? "";
      $memberDesignation = $member['tj_member2_designation'] ?? "";
      $memberUrl = $member['member2_url'] ?? "";
      $btnText   = $member['tj_member2_btn_text'] ?? [];
      $btnIcon   = $member['tj_member2_btn_icon'] ?? [];

      $link = !empty($memberUrl['url']) ? $memberUrl['url'] : '';
      $target = !empty($memberUrl['is_external']) ? '_blank' : '';
      $rel = !empty($memberUrl['nofollow']) ? 'nofollow' : '';

      $tjAnimation      = $member['tj_animation2'] ?? '';
      $tjAnimationName  = $member['tj_animation2_name'] ?? '';
      $tjAnimationDelay   = $member['tj_animation2_delay'] ?? '';

      $teamClass = 'team-item tj-el-team';

      $team_arg = 'tj-team-arg-' . $key;
      if (!empty($tjAnimation)) {
        $teamClass .= " wow $tjAnimationName";
        $this->add_render_attribute($team_arg, 'data-wow-delay', $tjAnimationDelay['size'] . "s");
      }
      $this->add_render_attribute($team_arg, 'class', $teamClass);

    ?>
      <div <?php $this->print_render_attribute_string($team_arg); ?>>

        <?php if (!empty($memberName) || !empty($memberDesignation)): ?>
          <div class="team-content">
            <?php if (!empty($memberName)): ?>
              <h3 class="title">
                <?php
                if (!empty($link)) :
                  $href = 'href="' . esc_attr($link) . '"';
                  $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
                  $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
                ?>
                  <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                    <?php echo tj_kses($memberName); ?>
                  </a>
                <?php else: ?>
                  <?php echo tj_kses($memberName); ?>
                <?php endif; ?>
              </h3>
            <?php endif; ?>

            <?php if (!empty($memberDesignation)): ?>
              <span class="designation"><?php echo esc_html__($memberDesignation, 'tjcore'); ?></span>
            <?php endif; ?>
          </div>
        <?php endif; ?>

        <div class="team-img">
          <img src="<?php echo esc_url($memberImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($memberImage['id'], '_wp_attachment_image_alt', true)); ?>">
        </div>

        <?php if (!empty($link)) :
          $href = 'href="' . esc_attr($link) . '"';
          $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
          $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
        ?>
          <a class="text-btn" <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
            <span class="btn-text"><span><?php echo esc_html($btnText); ?></span></span>
            <span class="btn-icon"><?php tj_render_icon($member, 'btn_icon', 'tj_member2_btn_icon'); ?></span>
          </a>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>