<?php

$teamMembers = !empty($settings['team_member_list']) ? $settings['team_member_list'] : "";
$image = !empty($settings['tj_image']) ? $settings['tj_image'] : "";

?>

<?php if (!empty($teamMembers)): ?>
  <div class="team-wrapper">
    <?php if (!empty($image['url'])): ?>
      <div class="team-img-wrap tj-el-image wow fadeInUp" data-wow-delay=".5s">
        <div id="team-img" class="team-img">
          <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($image['id'], '_wp_attachment_image_alt', true)); ?>">
        </div>
      </div>
    <?php endif; ?>
    <div class="team-item-wrap">
      <?php foreach ($teamMembers as $key => $member) :
        $memberImage = !empty($member['tj_member_image']) ? $member['tj_member_image'] : "";
        $memberName = !empty($member['tj_member_name']) ? $member['tj_member_name'] : "";
        $memberDesignation = !empty($member['tj_member_designation']) ? $member['tj_member_designation'] : "";
        $memberUrl = !empty($member['member_url']) ? $member['member_url'] : "";
        $btn_icon   = $member['tj_member_btn_icon'] ?? [];

        $link = !empty($memberUrl['url']) ? $memberUrl['url'] : '';
        $target = !empty($member['member_url']['is_external']) ? '_blank' : '';
        $rel = !empty($member['member_url']['nofollow']) ? 'nofollow' : '';

        // socials
        $showMemberSocials = !empty($member['show_member_socials']) ? $member['show_member_socials'] : false;
        $memberWebsite = !empty($member['website_link']) ? $member['website_link'] : "";
        $memberEmail = !empty($member['email_link']) ? $member['email_link'] : "";
        $memberPhone = !empty($member['phone_link']) ? $member['phone_link'] : "";
        $memberFacebook = !empty($member['facebook_link']) ? $member['facebook_link'] : "";
        $memberTwitter = !empty($member['twitter_link']) ? $member['twitter_link'] : "";
        $memberInstagram = !empty($member['instagram_link']) ? $member['instagram_link'] : "";
        $memberLinkedin = !empty($member['linkedin_link']) ? $member['linkedin_link'] : "";
        $memberPinterest = !empty($member['pinterest_link']) ? $member['pinterest_link'] : "";
        $memberYoutube = !empty($member['youtube_link']) ? $member['youtube_link'] : "";
        $memberVimeo = !empty($member['vimeo_link']) ? $member['vimeo_link'] : "";
        $memberGithub = !empty($member['github_link']) ? $member['github_link'] : "";
        $memberFlickr = !empty($member['flickr_link']) ? $member['flickr_link'] : "";
        $memberBehance = !empty($member['behance_link']) ? $member['behance_link'] : "";
        $memberDribbble = !empty($member['dribbble_link']) ? $member['dribbble_link'] : "";


        $tjAnimation      = $member['tj_animation'] ?? '';
        $tjAnimationName  = $member['tj_animation_name'] ?? '';
        $tjAnimationDelay   = $member['tj_animation_delay'] ?? '';

        $class = 'team-item tj-el-team';
        if ($key === 0) {
          $class .= ' active';
        }

        $team_arg = 'tj-team-arg-' . $key;
        if (!empty($tjAnimation)) {
          $teamClass = "$class wow $tjAnimationName";
          $this->add_render_attribute($team_arg, 'data-wow-delay', $tjAnimationDelay['size'] . "s");
        } else {
          $teamClass = "$class";
        }
        $this->add_render_attribute($team_arg, 'class', $teamClass);

      ?>
        <div <?php echo $this->get_render_attribute_string($team_arg); ?> <?php if (!empty($memberImage['url'])) { ?> data-src="<?php echo esc_url($memberImage['url']); ?>" <?php } ?>>
          <div class="team-item-inner">
            <?php if (!empty($memberName) || !empty($memberDesignation)): ?>
              <div class="team-content">
                <?php if (!empty($memberName)): ?>
                  <h3 class="title">
                    <?php
                    if (!empty($link)) :
                      $href = 'href="' . esc_attr($link) . '"';
                      $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
                      $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
                    ?>
                      <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                        <?php echo tj_kses($memberName); ?>
                      </a>
                    <?php else: ?>
                      <?php echo tj_kses($memberName); ?>
                    <?php endif; ?>
                  </h3>
                <?php endif; ?>
                <?php if (!empty($memberDesignation)): ?>
                  <span class="designation"><?php echo esc_html__($memberDesignation, 'tjcore'); ?></span>
                <?php endif; ?>
              </div>
            <?php endif; ?>
            <?php if ('yes' === $showMemberSocials): ?>
              <div class="social-links">
                <ul>
                  <?php if (!empty($memberWebsite)) : ?>
                    <li>
                      <a href="<?php echo esc_attr($memberWebsite); ?>">
                        <i class="fa-solid fa-globe"></i>
                      </a>
                    </li>
                  <?php endif;

                  if (!empty($memberEmail)) : ?>
                    <li>
                      <a href="<?php echo esc_attr($memberEmail); ?>">
                        <i class="fa-solid fa-envelope"></i>
                      </a>
                    </li>
                  <?php endif;

                  if (!empty($memberPhone)) : ?>
                    <li>
                      <a href="<?php echo esc_attr($memberPhone); ?>">
                        <i class="fa-solid fa-phone"></i>
                      </a>
                    </li>
                  <?php endif;

                  if (!empty($memberFacebook)) : ?>
                    <li>
                      <a href="<?php echo esc_attr($memberFacebook); ?>">
                        <i class="fa-brands fa-facebook-f"></i>
                      </a>
                    </li>
                  <?php endif;

                  if (!empty($memberTwitter)) : ?>
                    <li>
                      <a href="<?php echo esc_attr($memberTwitter); ?>">
                        <i class="fa-brands fa-twitter"></i>
                      </a>
                    </li>
                  <?php endif;

                  if (!empty($memberInstagram)) : ?>
                    <li>
                      <a href="<?php echo esc_attr($memberInstagram); ?>">
                        <i class="fa-brands fa-instagram"></i>
                      </a>
                    </li>
                  <?php endif;

                  if (!empty($memberLinkedin)) : ?>
                    <li>
                      <a href="<?php echo esc_attr($memberLinkedin); ?>">
                        <i class="fa-brands fa-linkedin-in"></i>
                      </a>
                    </li>
                  <?php endif;

                  if (!empty($memberPinterest)) :  ?>
                    <li>
                      <a href="<?php echo esc_attr($memberPinterest); ?>">
                        <i class="fa-brands fa-pinterest"></i>
                      </a>
                    </li>
                  <?php endif;

                  if (!empty($memberYoutube)) : ?>
                    <li>
                      <a href="<?php echo esc_attr($memberYoutube); ?>">
                        <i class="fa-brands fa-youtube"></i>
                      </a>
                    </li>
                  <?php endif;

                  if (!empty($memberVimeo)) : ?>
                    <li>
                      <a href="<?php echo esc_attr($memberVimeo); ?>">
                        <i class="fab fa-vimeo"></i>
                      </a>
                    </li>
                  <?php endif;

                  if (!empty($memberGithub)) : ?>
                    <li>
                      <a href="<?php echo esc_attr($memberGithub); ?>">
                        <i class="fab fa-github"></i>
                      </a>
                    </li>
                  <?php endif;

                  if (!empty($memberFlickr)) : ?>
                    <li>
                      <a href="<?php echo esc_attr($memberFlickr); ?>">
                        <i class="fab fa-flickr"></i>
                      </a>
                    </li>
                  <?php endif;

                  if (!empty($memberBehance)) : ?>
                    <li>
                      <a href="<?php echo esc_attr($memberBehance); ?>">
                        <i class="fab fa-behance"></i>
                      </a>
                    </li>
                  <?php endif;

                  if (!empty($memberDribbble)) : ?>
                    <li>
                      <a href="<?php echo esc_attr($memberDribbble); ?>">
                        <i class="fab fa-dribbble"></i>
                      </a>
                    </li>
                  <?php endif; ?>
                </ul>
              </div>
            <?php endif; ?>
            <?php
            if (!empty($link)) :
              $href = 'href="' . esc_attr($link) . '"';
              $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
              $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
            ?>
              <a class="team-link" <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                <?php tj_render_icon($member, 'btn_icon', 'tj_member_btn_icon'); ?>
              </a>
            <?php endif; ?>
          </div>

          <?php if (!empty($memberImage['url'])): ?>
            <div class="team-img-wrap tj-el-image">
              <div class="team-img">
                <img src="<?php echo esc_url($memberImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($memberImage['id'], '_wp_attachment_image_alt', true)); ?>">
              </div>
            </div>
          <?php endif; ?>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
<?php endif; ?>