<?php
$teams   = (!empty($settings['team_member_list'])) ? $settings['team_member_list'] : "";

$loop            = (isset($settings['slide_loop']) && !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no');
$autoplay        = (isset($settings['slide_autoplay']) && !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no');
$autoplayDelay   = (isset($settings['slide_autoplay_delay']) && !empty($settings['slide_autoplay_delay']) ? $settings['slide_autoplay_delay'] : '5000');

// animation
$tjAnimation       = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

$teamsClass = 'h7-team-wrapper carouselWrap fix';
if (!empty($tjAnimation) && !empty($tjAnimationName)) {
  $teamsClass .= ' wow ' . esc_attr($tjAnimationName);

  if (!empty($tjAnimationDelay)) {
    $this->add_render_attribute('tj_team_arg', 'data-wow-delay', esc_attr($tjAnimationDelay . 's'));
  }
}

$this->add_render_attribute('tj_team_arg', 'class', esc_attr($teamsClass));

if ('right-to-left' == $settings['marquee_slide']) {
  $slideContent = "";
} else {
  $slideContent = "dir=rtl";
}
?>
<div <?php echo $this->get_render_attribute_string('tj_team_arg'); ?> data-loop="<?php echo $loop; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>">
  <?php if (!empty($teams)): ?>
    <div class="h7-team-marquee swiper" <?php echo esc_attr($slideContent); ?> id="teamCarousel-<?php echo $this->get_id(); ?>">
      <div class="swiper-wrapper">
        <?php foreach ($teams as $team):
          $image = $team['tj_member_image'] ?? '';
          $memberName = $team['tj_member_name'] ?? "";
          $memberDesignation = $team['tj_member_designation'] ?? "";
          $memberUrl = $team['member_url'] ?? "";

          $link = !empty($memberUrl['url']) ? $memberUrl['url'] : '';
          $target = !empty($team['member_url']['is_external']) ? '_blank' : '';
          $rel = !empty($team['member_url']['nofollow']) ? 'nofollow' : '';
        ?>
          <div class="swiper-slide">
            <div class="team-item tj-el-team">
              <div class="team-content">
                <?php if (!empty($memberName)): ?>
                  <h5 class="title">
                    <?php
                    if (!empty($link)) :
                      $href = 'href="' . esc_attr($link) . '"';
                      $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
                      $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
                    ?>
                      <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                        <?php echo tj_kses($memberName); ?>
                      </a>
                    <?php else: ?>
                      <?php echo tj_kses($memberName); ?>
                    <?php endif; ?>
                  </h5>
                <?php endif; ?>

                <?php if (!empty($memberDesignation)): ?>
                  <span class="designation"><?php echo esc_html__($memberDesignation, 'tjcore'); ?></span>
                <?php endif; ?>
              </div>

              <?php if (!empty($image['url'])) : ?>
                <div class="team-img">
                  <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($image['id'], '_wp_attachment_image_alt', true)); ?>">
                </div>
              <?php endif; ?>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  <?php endif; ?>
</div>