<?php

$image_url = \Elementor\Group_Control_Image_Size::get_attachment_image_src($settings['tj_image']['id'], 'image_size', $settings);
if (empty($image_url)) {
  $image_url = \Elementor\Utils::get_placeholder_image_src();
}


$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $imageClass = "h9-about-img wow $tjAnimationName";
  $this->add_render_attribute('tj-image-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $imageClass = "h9-about-img";
}
$this->add_render_attribute('tj-image-arg', 'class', $imageClass);


?>

<div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?>>
  <?php if (!empty($settings['tj_image']['url'])) : ?>
    <div class="about-img tj-image">
      <img src="<?php echo esc_attr($image_url); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image']['id'], '_wp_attachment_image_alt', true)); ?>">
    </div>
  <?php endif; ?>

  <?php if (!empty($tj_title) || !empty($tj_content)) : ?>
    <div class="box-area tj-el-box">
      <div class="author-info wow fadeInUp" data-wow-delay=".3s">
        <?php if (!empty($tj_title)) : ?>
          <h4 class="title tj-el-title"><?php echo wp_kses_post($tj_title); ?></h4>
        <?php endif; ?>
        <?php if (!empty($tj_content)) : ?>
          <span class="designation tj-el-desc"> <?php echo wp_kses_post($tj_content); ?></span>
        <?php endif; ?>
      </div>
    </div>
  <?php endif; ?>
</div>